/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider.wechat;

import io.netty.handler.codec.http.HttpHeaderValues;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.skywalking.oap.server.core.alarm.AlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRulesWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatHookCallback
implements AlarmCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WechatHookCallback.class);
    private static final int HTTP_CONNECT_TIMEOUT = 1000;
    private static final int HTTP_CONNECTION_REQUEST_TIMEOUT = 1000;
    private static final int HTTP_SOCKET_TIMEOUT = 10000;
    private AlarmRulesWatcher alarmRulesWatcher;
    private RequestConfig requestConfig;

    public WechatHookCallback(AlarmRulesWatcher alarmRulesWatcher) {
        this.alarmRulesWatcher = alarmRulesWatcher;
        this.requestConfig = RequestConfig.custom().setConnectTimeout(1000).setConnectionRequestTimeout(1000).setSocketTimeout(10000).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAlarm(List<AlarmMessage> alarmMessages) {
        if (this.alarmRulesWatcher.getWechatSettings() == null || this.alarmRulesWatcher.getWechatSettings().getWebhooks().isEmpty()) {
            return;
        }
        CloseableHttpClient httpClient = HttpClients.custom().build();
        try {
            this.alarmRulesWatcher.getWechatSettings().getWebhooks().forEach(url -> alarmMessages.forEach(alarmMessage -> {
                String requestBody = String.format(this.alarmRulesWatcher.getWechatSettings().getTextTemplate(), alarmMessage.getAlarmMessage());
                this.sendAlarmMessage(httpClient, (String)url, requestBody);
            }));
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAlarmMessage(CloseableHttpClient httpClient, String url, String requestBody) {
        CloseableHttpResponse httpResponse = null;
        try {
            HttpPost post = new HttpPost(url);
            post.setConfig(this.requestConfig);
            post.setHeader("Accept", HttpHeaderValues.APPLICATION_JSON.toString());
            post.setHeader("Content-Type", HttpHeaderValues.APPLICATION_JSON.toString());
            StringEntity entity = new StringEntity(requestBody, ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)entity);
            httpResponse = httpClient.execute((HttpUriRequest)post);
            StatusLine statusLine = httpResponse.getStatusLine();
            if (statusLine != null && statusLine.getStatusCode() != 200) {
                log.error("send wechat alarm to {} failure. Response code: {} ", (Object)url, (Object)statusLine.getStatusCode());
            }
        }
        catch (Throwable e) {
            log.error("send wechat alarm to {} failure.", (Object)url, (Object)e);
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

