/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import com.google.gson.Gson;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.skywalking.oap.server.core.alarm.AlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRulesWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookCallback
implements AlarmCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebhookCallback.class);
    private static final int HTTP_CONNECT_TIMEOUT = 1000;
    private static final int HTTP_CONNECTION_REQUEST_TIMEOUT = 1000;
    private static final int HTTP_SOCKET_TIMEOUT = 10000;
    private AlarmRulesWatcher alarmRulesWatcher;
    private RequestConfig requestConfig;
    private Gson gson = new Gson();

    public WebhookCallback(AlarmRulesWatcher alarmRulesWatcher) {
        this.alarmRulesWatcher = alarmRulesWatcher;
        this.requestConfig = RequestConfig.custom().setConnectTimeout(1000).setConnectionRequestTimeout(1000).setSocketTimeout(10000).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAlarm(List<AlarmMessage> alarmMessage) {
        if (this.alarmRulesWatcher.getWebHooks().isEmpty()) {
            return;
        }
        CloseableHttpClient httpClient = HttpClients.custom().build();
        try {
            this.alarmRulesWatcher.getWebHooks().forEach(url -> {
                HttpPost post = new HttpPost(url);
                post.setConfig(this.requestConfig);
                post.setHeader("Accept", HttpHeaderValues.APPLICATION_JSON.toString());
                post.setHeader("Content-Type", HttpHeaderValues.APPLICATION_JSON.toString());
                CloseableHttpResponse httpResponse = null;
                try {
                    StringEntity entity = new StringEntity(this.gson.toJson((Object)alarmMessage), StandardCharsets.UTF_8);
                    post.setEntity((HttpEntity)entity);
                    httpResponse = httpClient.execute((HttpUriRequest)post);
                    StatusLine statusLine = httpResponse.getStatusLine();
                    if (statusLine != null && statusLine.getStatusCode() != 200) {
                        log.error("send alarm to " + url + " failure. Response code: " + statusLine.getStatusCode());
                    }
                }
                catch (UnsupportedEncodingException e) {
                    log.error("Alarm to JSON error, " + e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    log.error("send alarm to " + url + " failure.", (Throwable)e);
                }
                finally {
                    if (httpResponse != null) {
                        try {
                            httpResponse.close();
                        }
                        catch (IOException e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            });
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

