/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import org.apache.skywalking.oap.server.core.alarm.provider.MetricsValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Threshold {
    private static final Logger LOGGER = LoggerFactory.getLogger(Threshold.class);
    private static final String NONE_THRESHOLD = "-";
    private String alarmRuleName;
    private final String threshold;
    private int intThreshold;
    private double doubleThreshold;
    private long longThreshold;
    private Integer[] intValuesThreshold;

    public Threshold(String alarmRuleName, String threshold) {
        this.alarmRuleName = alarmRuleName;
        this.threshold = threshold;
    }

    public int getIntThreshold() {
        return this.intThreshold;
    }

    public double getDoubleThreshold() {
        return this.doubleThreshold;
    }

    public long getLongThreshold() {
        return this.longThreshold;
    }

    public Integer[] getIntValuesThreshold() {
        return this.intValuesThreshold;
    }

    public void setType(MetricsValueType type) {
        try {
            switch (type) {
                case INT: {
                    this.intThreshold = Integer.parseInt(this.threshold);
                    break;
                }
                case LONG: {
                    this.longThreshold = Long.parseLong(this.threshold);
                    break;
                }
                case DOUBLE: {
                    this.doubleThreshold = Double.parseDouble(this.threshold);
                    break;
                }
                case MULTI_INTS: {
                    String[] strings = this.threshold.split(",");
                    this.intValuesThreshold = new Integer[strings.length];
                    for (int i = 0; i < strings.length; ++i) {
                        String thresholdItem = strings[i].trim();
                        this.intValuesThreshold[i] = NONE_THRESHOLD.equals(thresholdItem) ? null : Integer.valueOf(Integer.parseInt(thresholdItem));
                    }
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Alarm rule {} threshold doesn't match the metrics type, expected type: {}", (Object)this.alarmRuleName, (Object)type);
        }
    }
}

