/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.alarm.AlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.EndpointMetaInAlarm;
import org.apache.skywalking.oap.server.core.alarm.EndpointRelationMetaInAlarm;
import org.apache.skywalking.oap.server.core.alarm.MetaInAlarm;
import org.apache.skywalking.oap.server.core.alarm.MetricsNotify;
import org.apache.skywalking.oap.server.core.alarm.ServiceInstanceMetaInAlarm;
import org.apache.skywalking.oap.server.core.alarm.ServiceInstanceRelationMetaInAlarm;
import org.apache.skywalking.oap.server.core.alarm.ServiceMetaInAlarm;
import org.apache.skywalking.oap.server.core.alarm.ServiceRelationMetaInAlarm;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmCore;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRulesWatcher;
import org.apache.skywalking.oap.server.core.alarm.provider.EventHookCallback;
import org.apache.skywalking.oap.server.core.alarm.provider.RunningRule;
import org.apache.skywalking.oap.server.core.alarm.provider.WebhookCallback;
import org.apache.skywalking.oap.server.core.alarm.provider.dingtalk.DingtalkHookCallback;
import org.apache.skywalking.oap.server.core.alarm.provider.feishu.FeishuHookCallback;
import org.apache.skywalking.oap.server.core.alarm.provider.grpc.GRPCCallback;
import org.apache.skywalking.oap.server.core.alarm.provider.slack.SlackhookCallback;
import org.apache.skywalking.oap.server.core.alarm.provider.wechat.WechatHookCallback;
import org.apache.skywalking.oap.server.core.alarm.provider.welink.WeLinkHookCallback;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.MetricsMetaInfo;
import org.apache.skywalking.oap.server.core.analysis.metrics.WithMetadata;
import org.apache.skywalking.oap.server.core.source.DefaultScopeDefine;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyHandler
implements MetricsNotify {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotifyHandler.class);
    private final AlarmCore core;
    private final AlarmRulesWatcher alarmRulesWatcher;
    private final ModuleManager manager;

    public NotifyHandler(AlarmRulesWatcher alarmRulesWatcher, ModuleManager manager) {
        this.alarmRulesWatcher = alarmRulesWatcher;
        this.core = new AlarmCore(alarmRulesWatcher);
        this.manager = manager;
    }

    public void notify(Metrics metrics) {
        ServiceMetaInAlarm metaInAlarm;
        WithMetadata withMetadata = (WithMetadata)metrics;
        MetricsMetaInfo meta = withMetadata.getMeta();
        int scope = meta.getScope();
        if (!(DefaultScopeDefine.inServiceCatalog((int)scope) || DefaultScopeDefine.inServiceInstanceCatalog((int)scope) || DefaultScopeDefine.inEndpointCatalog((int)scope) || DefaultScopeDefine.inServiceRelationCatalog((int)scope) || DefaultScopeDefine.inServiceInstanceRelationCatalog((int)scope) || DefaultScopeDefine.inEndpointRelationCatalog((int)scope))) {
            return;
        }
        if (DefaultScopeDefine.inServiceCatalog((int)scope)) {
            String serviceId = meta.getId();
            IDManager.ServiceID.ServiceIDDefinition serviceIDDefinition = IDManager.ServiceID.analysisId((String)serviceId);
            ServiceMetaInAlarm serviceMetaInAlarm = new ServiceMetaInAlarm();
            serviceMetaInAlarm.setMetricsName(meta.getMetricsName());
            serviceMetaInAlarm.setId(serviceId);
            serviceMetaInAlarm.setName(serviceIDDefinition.getName());
            metaInAlarm = serviceMetaInAlarm;
        } else if (DefaultScopeDefine.inServiceInstanceCatalog((int)scope)) {
            String instanceId = meta.getId();
            IDManager.ServiceInstanceID.InstanceIDDefinition instanceIDDefinition = IDManager.ServiceInstanceID.analysisId((String)instanceId);
            IDManager.ServiceID.ServiceIDDefinition serviceIDDefinition = IDManager.ServiceID.analysisId((String)instanceIDDefinition.getServiceId());
            ServiceInstanceMetaInAlarm instanceMetaInAlarm = new ServiceInstanceMetaInAlarm();
            instanceMetaInAlarm.setMetricsName(meta.getMetricsName());
            instanceMetaInAlarm.setId(instanceId);
            instanceMetaInAlarm.setName(instanceIDDefinition.getName() + " of " + serviceIDDefinition.getName());
            metaInAlarm = instanceMetaInAlarm;
        } else if (DefaultScopeDefine.inEndpointCatalog((int)scope)) {
            String endpointId = meta.getId();
            IDManager.EndpointID.EndpointIDDefinition endpointIDDefinition = IDManager.EndpointID.analysisId((String)endpointId);
            IDManager.ServiceID.ServiceIDDefinition serviceIDDefinition = IDManager.ServiceID.analysisId((String)endpointIDDefinition.getServiceId());
            EndpointMetaInAlarm endpointMetaInAlarm = new EndpointMetaInAlarm();
            endpointMetaInAlarm.setMetricsName(meta.getMetricsName());
            endpointMetaInAlarm.setId(meta.getId());
            endpointMetaInAlarm.setName(endpointIDDefinition.getEndpointName() + " in " + serviceIDDefinition.getName());
            metaInAlarm = endpointMetaInAlarm;
        } else if (DefaultScopeDefine.inServiceRelationCatalog((int)scope)) {
            String serviceRelationId = meta.getId();
            IDManager.ServiceID.ServiceRelationDefine serviceRelationDefine = IDManager.ServiceID.analysisRelationId((String)serviceRelationId);
            IDManager.ServiceID.ServiceIDDefinition sourceIdDefinition = IDManager.ServiceID.analysisId((String)serviceRelationDefine.getSourceId());
            IDManager.ServiceID.ServiceIDDefinition destIdDefinition = IDManager.ServiceID.analysisId((String)serviceRelationDefine.getDestId());
            ServiceRelationMetaInAlarm serviceRelationMetaInAlarm = new ServiceRelationMetaInAlarm();
            serviceRelationMetaInAlarm.setMetricsName(meta.getMetricsName());
            serviceRelationMetaInAlarm.setId(serviceRelationId);
            serviceRelationMetaInAlarm.setName(sourceIdDefinition.getName() + " to " + destIdDefinition.getName());
            metaInAlarm = serviceRelationMetaInAlarm;
        } else if (DefaultScopeDefine.inServiceInstanceRelationCatalog((int)scope)) {
            String instanceRelationId = meta.getId();
            IDManager.ServiceInstanceID.ServiceInstanceRelationDefine serviceRelationDefine = IDManager.ServiceInstanceID.analysisRelationId((String)instanceRelationId);
            IDManager.ServiceInstanceID.InstanceIDDefinition sourceIdDefinition = IDManager.ServiceInstanceID.analysisId((String)serviceRelationDefine.getSourceId());
            IDManager.ServiceID.ServiceIDDefinition sourceServiceId = IDManager.ServiceID.analysisId((String)sourceIdDefinition.getServiceId());
            IDManager.ServiceInstanceID.InstanceIDDefinition destIdDefinition = IDManager.ServiceInstanceID.analysisId((String)serviceRelationDefine.getDestId());
            IDManager.ServiceID.ServiceIDDefinition destServiceId = IDManager.ServiceID.analysisId((String)destIdDefinition.getServiceId());
            ServiceInstanceRelationMetaInAlarm instanceRelationMetaInAlarm = new ServiceInstanceRelationMetaInAlarm();
            instanceRelationMetaInAlarm.setMetricsName(meta.getMetricsName());
            instanceRelationMetaInAlarm.setId(instanceRelationId);
            instanceRelationMetaInAlarm.setName(sourceIdDefinition.getName() + " of " + sourceServiceId.getName() + " to " + destIdDefinition.getName() + " of " + destServiceId.getName());
            metaInAlarm = instanceRelationMetaInAlarm;
        } else if (DefaultScopeDefine.inEndpointRelationCatalog((int)scope)) {
            String endpointRelationId = meta.getId();
            IDManager.EndpointID.EndpointRelationDefine endpointRelationDefine = IDManager.EndpointID.analysisRelationId((String)endpointRelationId);
            IDManager.ServiceID.ServiceIDDefinition sourceService = IDManager.ServiceID.analysisId((String)endpointRelationDefine.getSourceServiceId());
            IDManager.ServiceID.ServiceIDDefinition destService = IDManager.ServiceID.analysisId((String)endpointRelationDefine.getDestServiceId());
            EndpointRelationMetaInAlarm endpointRelationMetaInAlarm = new EndpointRelationMetaInAlarm();
            endpointRelationMetaInAlarm.setMetricsName(meta.getMetricsName());
            endpointRelationMetaInAlarm.setId(endpointRelationId);
            endpointRelationMetaInAlarm.setName(endpointRelationDefine.getSource() + " in " + sourceService.getName() + " to " + endpointRelationDefine.getDest() + " in " + destService.getName());
            metaInAlarm = endpointRelationMetaInAlarm;
        } else {
            return;
        }
        List<RunningRule> runningRules = this.core.findRunningRule(meta.getMetricsName());
        if (runningRules == null) {
            return;
        }
        runningRules.forEach(arg_0 -> NotifyHandler.lambda$notify$0((MetaInAlarm)metaInAlarm, metrics, arg_0));
    }

    public void init(AlarmCallback ... callbacks) {
        ArrayList<AlarmCallback> allCallbacks = new ArrayList<AlarmCallback>(Arrays.asList(callbacks));
        allCallbacks.add(new WebhookCallback(this.alarmRulesWatcher));
        allCallbacks.add(new GRPCCallback(this.alarmRulesWatcher));
        allCallbacks.add(new SlackhookCallback(this.alarmRulesWatcher));
        allCallbacks.add(new WechatHookCallback(this.alarmRulesWatcher));
        allCallbacks.add(new DingtalkHookCallback(this.alarmRulesWatcher));
        allCallbacks.add(new FeishuHookCallback(this.alarmRulesWatcher));
        allCallbacks.add(new EventHookCallback(this.manager));
        allCallbacks.add(new WeLinkHookCallback(this.alarmRulesWatcher));
        this.core.start(allCallbacks);
    }

    private static /* synthetic */ void lambda$notify$0(MetaInAlarm metaInAlarm, Metrics metrics, RunningRule rule) {
        rule.in(metaInAlarm, metrics);
    }
}

