/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.skywalking.apm.network.event.v3.Event;
import org.apache.skywalking.apm.network.event.v3.Source;
import org.apache.skywalking.apm.network.event.v3.Type;
import org.apache.skywalking.oap.server.analyzer.event.EventAnalyzerService;
import org.apache.skywalking.oap.server.core.alarm.AlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class EventHookCallback
implements AlarmCallback {
    private final ModuleManager manager;

    public EventHookCallback(ModuleManager manager) {
        this.manager = manager;
    }

    public void doAlarm(List<AlarmMessage> alarmMessage) {
        EventAnalyzerService analyzerService = (EventAnalyzerService)this.manager.find("event-analyzer").provider().getService(EventAnalyzerService.class);
        alarmMessage.forEach(a -> {
            for (Event event : this.constructCurrentEvent((AlarmMessage)a)) {
                analyzerService.analyze(event);
            }
        });
    }

    private List<Event> constructCurrentEvent(AlarmMessage msg) {
        ArrayList<Event> events = new ArrayList<Event>(2);
        long now = System.currentTimeMillis();
        Event.Builder builder = Event.newBuilder().setUuid(UUID.randomUUID().toString()).setName("Alarm").setStartTime(now - (long)(msg.getPeriod() * 60 * 1000)).setMessage(msg.getAlarmMessage()).setType(Type.Error).setEndTime(now);
        switch (msg.getScopeId()) {
            case 1: {
                IDManager.ServiceID.ServiceIDDefinition serviceIdDef = IDManager.ServiceID.analysisId((String)msg.getId0());
                builder.setSource(Source.newBuilder().setService(serviceIdDef.getName()).build());
                events.add(builder.build());
                break;
            }
            case 4: {
                IDManager.ServiceID.ServiceIDDefinition sourceServiceIdDef = IDManager.ServiceID.analysisId((String)msg.getId0());
                builder.setSource(Source.newBuilder().setService(sourceServiceIdDef.getName()).build());
                events.add(builder.build());
                IDManager.ServiceID.ServiceIDDefinition destServiceIdDef = IDManager.ServiceID.analysisId((String)msg.getId1());
                builder.setSource(Source.newBuilder().setService(destServiceIdDef.getName()).build()).setUuid(UUID.randomUUID().toString());
                events.add(builder.build());
                break;
            }
            case 2: {
                IDManager.ServiceInstanceID.InstanceIDDefinition instanceIdDef = IDManager.ServiceInstanceID.analysisId((String)msg.getId0());
                builder.setSource(Source.newBuilder().setServiceInstance(instanceIdDef.getName()).setService(IDManager.ServiceID.analysisId((String)instanceIdDef.getServiceId()).getName()).build());
                events.add(builder.build());
                break;
            }
            case 5: {
                IDManager.ServiceInstanceID.InstanceIDDefinition sourceInstanceIdDef = IDManager.ServiceInstanceID.analysisId((String)msg.getId0());
                builder.setSource(Source.newBuilder().setServiceInstance(sourceInstanceIdDef.getName()).setService(IDManager.ServiceID.analysisId((String)sourceInstanceIdDef.getServiceId()).getName()).build());
                events.add(builder.build());
                IDManager.ServiceInstanceID.InstanceIDDefinition destInstanceIdDef = IDManager.ServiceInstanceID.analysisId((String)msg.getId1());
                builder.setSource(Source.newBuilder().setServiceInstance(destInstanceIdDef.getName()).setService(IDManager.ServiceID.analysisId((String)destInstanceIdDef.getServiceId()).getName()).build()).setUuid(UUID.randomUUID().toString());
                events.add(builder.build());
                break;
            }
            case 3: {
                IDManager.EndpointID.EndpointIDDefinition endpointIDDef = IDManager.EndpointID.analysisId((String)msg.getId0());
                builder.setSource(Source.newBuilder().setEndpoint(endpointIDDef.getEndpointName()).setService(IDManager.ServiceID.analysisId((String)endpointIDDef.getServiceId()).getName()).build());
                events.add(builder.build());
                break;
            }
            case 6: {
                IDManager.EndpointID.EndpointIDDefinition sourceEndpointIDDef = IDManager.EndpointID.analysisId((String)msg.getId0());
                builder.setSource(Source.newBuilder().setEndpoint(sourceEndpointIDDef.getEndpointName()).setService(IDManager.ServiceID.analysisId((String)sourceEndpointIDDef.getServiceId()).getName()).build());
                events.add(builder.build());
                IDManager.EndpointID.EndpointIDDefinition destEndpointIDDef = IDManager.EndpointID.analysisId((String)msg.getId1());
                builder.setSource(Source.newBuilder().setEndpoint(destEndpointIDDef.getEndpointName()).setService(IDManager.ServiceID.analysisId((String)destEndpointIDDef.getServiceId()).getName()).build()).setUuid(UUID.randomUUID().toString());
                events.add(builder.build());
            }
        }
        return events;
    }
}

