/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.configuration.api.ConfigChangeWatcher;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRule;
import org.apache.skywalking.oap.server.core.alarm.provider.CompositeAlarmRule;
import org.apache.skywalking.oap.server.core.alarm.provider.CompositeRuleEvaluator;
import org.apache.skywalking.oap.server.core.alarm.provider.Rules;
import org.apache.skywalking.oap.server.core.alarm.provider.RulesReader;
import org.apache.skywalking.oap.server.core.alarm.provider.RunningRule;
import org.apache.skywalking.oap.server.core.alarm.provider.dingtalk.DingtalkSettings;
import org.apache.skywalking.oap.server.core.alarm.provider.expression.Expression;
import org.apache.skywalking.oap.server.core.alarm.provider.expression.ExpressionContext;
import org.apache.skywalking.oap.server.core.alarm.provider.feishu.FeishuSettings;
import org.apache.skywalking.oap.server.core.alarm.provider.grpc.GRPCAlarmSetting;
import org.apache.skywalking.oap.server.core.alarm.provider.slack.SlackSettings;
import org.apache.skywalking.oap.server.core.alarm.provider.wechat.WechatSettings;
import org.apache.skywalking.oap.server.core.alarm.provider.welink.WeLinkSettings;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmRulesWatcher
extends ConfigChangeWatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlarmRulesWatcher.class);
    private volatile Map<String, List<RunningRule>> runningContext = new HashMap<String, List<RunningRule>>();
    private volatile Map<AlarmRule, RunningRule> alarmRuleRunningRuleMap = new HashMap<AlarmRule, RunningRule>();
    private volatile Rules rules;
    private volatile String settingsString = "";
    private final CompositeRuleEvaluator compositeRuleEvaluator;

    public AlarmRulesWatcher(Rules defaultRules, ModuleProvider provider) {
        super("alarm", provider, "alarm-settings");
        Expression expression = new Expression(new ExpressionContext());
        this.compositeRuleEvaluator = new CompositeRuleEvaluator(expression);
        this.notify(defaultRules);
    }

    public void notify(ConfigChangeWatcher.ConfigChangeEvent value) {
        if (value.getEventType().equals((Object)ConfigChangeWatcher.EventType.DELETE)) {
            this.settingsString = "";
            this.notify(new Rules());
        } else {
            this.settingsString = value.getNewValue();
            RulesReader rulesReader = new RulesReader(new StringReader(value.getNewValue()));
            Rules rules = rulesReader.readRules();
            this.notify(rules);
        }
    }

    void notify(Rules newRules) {
        HashMap<AlarmRule, RunningRule> newAlarmRuleRunningRuleMap = new HashMap<AlarmRule, RunningRule>();
        HashMap<String, List<RunningRule>> newRunningContext = new HashMap<String, List<RunningRule>>();
        newRules.getRules().forEach(rule -> {
            RunningRule runningRule = this.alarmRuleRunningRuleMap.getOrDefault(rule, new RunningRule((AlarmRule)rule));
            newAlarmRuleRunningRuleMap.put((AlarmRule)rule, runningRule);
            String metricsName = rule.getMetricsName();
            List runningRules = newRunningContext.computeIfAbsent(metricsName, key -> new ArrayList());
            runningRules.add(runningRule);
        });
        this.rules = newRules;
        this.runningContext = newRunningContext;
        this.alarmRuleRunningRuleMap = newAlarmRuleRunningRuleMap;
        log.info("Update alarm rules to {}", (Object)this.rules);
    }

    public String value() {
        return this.settingsString;
    }

    public List<AlarmRule> getRules() {
        return this.rules.getRules();
    }

    public List<CompositeAlarmRule> getCompositeRules() {
        return this.rules.getCompositeRules();
    }

    public List<String> getWebHooks() {
        return this.rules.getWebhooks();
    }

    public GRPCAlarmSetting getGrpchookSetting() {
        return this.rules.getGrpchookSetting();
    }

    public SlackSettings getSlackSettings() {
        return this.rules.getSlacks();
    }

    public WechatSettings getWechatSettings() {
        return this.rules.getWecchats();
    }

    public DingtalkSettings getDingtalkSettings() {
        return this.rules.getDingtalks();
    }

    public FeishuSettings getFeishuSettings() {
        return this.rules.getFeishus();
    }

    public WeLinkSettings getWeLinkSettings() {
        return this.rules.getWelinks();
    }

    @Generated
    public Map<String, List<RunningRule>> getRunningContext() {
        return this.runningContext;
    }

    @Generated
    public CompositeRuleEvaluator getCompositeRuleEvaluator() {
        return this.compositeRuleEvaluator;
    }
}

