/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.sync.data.http;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import okhttp3.OkHttpClient;
import org.apache.shenyu.common.constant.HttpConstants;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.DiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.ProxySelectorDataSubscriber;
import org.apache.shenyu.sync.data.api.SyncDataService;
import org.apache.shenyu.sync.data.http.AccessTokenManager;
import org.apache.shenyu.sync.data.http.HttpSyncDataService;
import org.apache.shenyu.sync.data.http.config.HttpConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={HttpSyncDataService.class})
@ConditionalOnProperty(prefix="shenyu.sync.http", name={"url"})
public class HttpSyncDataConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpSyncDataConfiguration.class);

    @Bean
    @ConfigurationProperties(prefix="shenyu.sync.http")
    public HttpConfig httpConfig() {
        return new HttpConfig();
    }

    @Bean
    @Qualifier(value="httpSyncClient")
    public OkHttpClient okHttpClient(HttpConfig httpConfig) {
        return new OkHttpClient.Builder().readTimeout(Duration.ofMillis(Objects.isNull(httpConfig.getReadTimeout()) ? (long)((int)HttpConstants.CLIENT_POLLING_READ_TIMEOUT) : (long)httpConfig.getReadTimeout().intValue())).connectTimeout(Duration.ofMillis(Objects.isNull(httpConfig.getConnectionTimeout()) ? HttpConstants.CLIENT_POLLING_CONNECT_TIMEOUT : (long)httpConfig.getConnectionTimeout().intValue())).writeTimeout(Duration.ofMillis(Objects.isNull(httpConfig.getWriteTimeout()) ? (long)((int)HttpConstants.CLIENT_POLLING_WRITE_TIMEOUT) : (long)httpConfig.getWriteTimeout().intValue())).build();
    }

    @Bean
    public AccessTokenManager accessTokenManager(HttpConfig httpConfig, @Qualifier(value="httpSyncClient") OkHttpClient okHttpClient) {
        return new AccessTokenManager(okHttpClient, httpConfig);
    }

    @Bean
    public SyncDataService httpSyncDataService(ObjectProvider<HttpConfig> httpConfig, ObjectProvider<PluginDataSubscriber> pluginSubscriber, @Qualifier(value="httpSyncClient") ObjectProvider<OkHttpClient> okHttpClient, ObjectProvider<List<MetaDataSubscriber>> metaSubscribers, ObjectProvider<List<AuthDataSubscriber>> authSubscribers, ObjectProvider<AccessTokenManager> accessTokenManager, ObjectProvider<List<ProxySelectorDataSubscriber>> proxySelectorDataSubscribers, ObjectProvider<List<DiscoveryUpstreamDataSubscriber>> discoveryUpstreamDataSubscribers) {
        LOGGER.info("you use http long pull sync shenyu data");
        return new HttpSyncDataService((HttpConfig)Objects.requireNonNull(httpConfig.getIfAvailable()), (PluginDataSubscriber)Objects.requireNonNull(pluginSubscriber.getIfAvailable()), (OkHttpClient)Objects.requireNonNull(okHttpClient.getIfAvailable()), (List)metaSubscribers.getIfAvailable(Collections::emptyList), (List)authSubscribers.getIfAvailable(Collections::emptyList), (List)proxySelectorDataSubscribers.getIfAvailable(Collections::emptyList), (List)discoveryUpstreamDataSubscribers.getIfAvailable(Collections::emptyList), (AccessTokenManager)Objects.requireNonNull(accessTokenManager.getIfAvailable()));
    }
}

