/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.server.zookeeper;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.client.server.api.ShenyuClientServerRegisterPublisher;
import org.apache.shenyu.register.client.server.api.ShenyuClientServerRegisterRepository;
import org.apache.shenyu.register.client.server.zookeeper.ZookeeperClient;
import org.apache.shenyu.register.client.server.zookeeper.ZookeeperConfig;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.apache.shenyu.register.common.path.RegisterPathConstants;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class ZookeeperClientServerRegisterRepository
implements ShenyuClientServerRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperClientServerRegisterRepository.class);
    private ShenyuClientServerRegisterPublisher publisher;
    private ZookeeperClient client;

    public void init(ShenyuClientServerRegisterPublisher publisher, ShenyuRegisterCenterConfig config) {
        this.init(config);
        this.publisher = publisher;
        Properties props = config.getProps();
        int sessionTimeout = Integer.parseInt(props.getProperty("sessionTimeout", "3000"));
        int connectionTimeout = Integer.parseInt(props.getProperty("connectionTimeout", "3000"));
        int baseSleepTime = Integer.parseInt(props.getProperty("baseSleepTime", "1000"));
        int maxRetries = Integer.parseInt(props.getProperty("maxRetries", "3"));
        int maxSleepTime = Integer.parseInt(props.getProperty("maxSleepTime", String.valueOf(Integer.MAX_VALUE)));
        ZookeeperConfig zkConfig = new ZookeeperConfig(config.getServerLists());
        zkConfig.setBaseSleepTimeMilliseconds(baseSleepTime).setMaxRetries(maxRetries).setMaxSleepTimeMilliseconds(maxSleepTime).setSessionTimeoutMilliseconds(sessionTimeout).setConnectionTimeoutMilliseconds(connectionTimeout);
        String digest = props.getProperty("digest");
        if (!StringUtils.isEmpty((CharSequence)digest)) {
            zkConfig.setDigest(digest);
        }
        this.client = new ZookeeperClient(zkConfig);
        this.client.start();
        this.initSubscribe();
    }

    public void close() {
        this.client.close();
    }

    private void initSubscribe() {
        RpcTypeEnum.acquireSupportMetadatas().forEach(rpcTypeEnum -> this.subscribeMetaData(rpcTypeEnum.getName()));
        RpcTypeEnum.acquireSupportURIs().forEach(rpcTypeEnum -> this.subscribeURI(rpcTypeEnum.getName()));
    }

    private void subscribeURI(String rpcType) {
        String contextPathParent = RegisterPathConstants.buildURIContextPathParent((String)rpcType);
        this.client.addCache(contextPathParent, new URICacheListener());
    }

    private void subscribeMetaData(String rpcType) {
        String contextPathParent = RegisterPathConstants.buildMetaDataContextPathParent((String)rpcType);
        this.client.addCache(contextPathParent, new MetadataCacheListener());
    }

    private void publishMetadata(String data) {
        this.publisher.publish((Collection)Lists.newArrayList((Object[])new MetaDataRegisterDTO[]{(MetaDataRegisterDTO)GsonUtils.getInstance().fromJson(data, MetaDataRegisterDTO.class)}));
    }

    private void publishRegisterURI(List<URIRegisterDTO> registerDTOList) {
        this.publisher.publish(registerDTOList);
    }

    class URICacheListener
    extends AbstractRegisterListener {
        URICacheListener() {
        }

        @Override
        public void event(TreeCacheEvent.Type type, String path, ChildData data) {
            if (data.getData() == null || data.getData().length == 0) {
                return;
            }
            URIRegisterDTO uriRegisterDTO = (URIRegisterDTO)GsonUtils.getInstance().fromJson(new String(data.getData()), URIRegisterDTO.class);
            if (uriRegisterDTO == null) {
                return;
            }
            switch (type) {
                case NODE_ADDED: {
                    uriRegisterDTO.setEventType(EventType.REGISTER);
                    ZookeeperClientServerRegisterRepository.this.publishRegisterURI(Collections.singletonList(uriRegisterDTO));
                    break;
                }
                case NODE_REMOVED: {
                    uriRegisterDTO.setEventType(EventType.OFFLINE);
                    ZookeeperClientServerRegisterRepository.this.publishRegisterURI(Collections.singletonList(uriRegisterDTO));
                    break;
                }
            }
        }
    }

    class MetadataCacheListener
    extends AbstractRegisterListener {
        MetadataCacheListener() {
        }

        @Override
        public void event(TreeCacheEvent.Type type, String path, ChildData data) {
            if (!path.contains("/shenyu/register")) {
                return;
            }
            Optional.ofNullable(data).ifPresent(e -> {
                String str = new String(data.getData(), StandardCharsets.UTF_8);
                ZookeeperClientServerRegisterRepository.this.publishMetadata(str);
                LOGGER.info("zookeeper register metadata success: {}", (Object)str);
            });
        }
    }

    static abstract class AbstractRegisterListener
    implements TreeCacheListener {
        AbstractRegisterListener() {
        }

        public final void childEvent(CuratorFramework client, TreeCacheEvent event) {
            ChildData childData = event.getData();
            if (null == childData) {
                return;
            }
            String path = childData.getPath();
            if (Strings.isNullOrEmpty((String)path)) {
                return;
            }
            this.event(event.getType(), path, childData);
        }

        protected abstract void event(TreeCacheEvent.Type var1, String var2, ChildData var3);
    }
}

