/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.server.apollo;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.client.server.api.ShenyuClientServerRegisterPublisher;
import org.apache.shenyu.register.client.server.api.ShenyuClientServerRegisterRepository;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.apache.shenyu.spi.Join;

@Join
public class ApolloClientServerRegisterRepository
implements ShenyuClientServerRegisterRepository {
    private static final String APOLLO_CLUSTER = "apollo.cluster";
    private static final String PROP_APP_ID = "app.id";
    private static final String PROP_APOLLO_META = "apollo.meta";
    private static final String APOLLO_NAMESPACE = "apollo.bootstrap.namespace";
    private ShenyuClientServerRegisterPublisher publisher;
    private Config config;

    public void init(ShenyuClientServerRegisterPublisher publisher, ShenyuRegisterCenterConfig config) {
        this.publisher = publisher;
        Properties properties = config.getProps();
        String meta = config.getServerLists();
        String appId = properties.getProperty("appId");
        String clusterName = properties.getProperty("clusterName", "default");
        String namespace = properties.getProperty("namespace", "application");
        Optional.ofNullable(appId).ifPresent(x -> System.setProperty(PROP_APP_ID, x));
        Optional.ofNullable(meta).ifPresent(x -> System.setProperty(PROP_APOLLO_META, x));
        Optional.ofNullable(clusterName).ifPresent(x -> System.setProperty(APOLLO_CLUSTER, x));
        Optional.ofNullable(namespace).ifPresent(x -> System.setProperty(APOLLO_NAMESPACE, x));
        this.config = ConfigService.getAppConfig();
        this.initSubscribe();
    }

    private void initSubscribe() {
        Set propertyNames = this.config.getPropertyNames();
        for (String propertyName : propertyNames) {
            String property = this.config.getProperty(propertyName, "{}");
            if (propertyName.startsWith("/shenyu/register/metadata")) {
                this.publishMetadata(property);
                continue;
            }
            if (!propertyName.startsWith("/shenyu/register/uri")) continue;
            this.publishRegisterURI(property);
        }
        this.subscribeMetadata();
        this.subscribeUri();
    }

    private void subscribeMetadata() {
        this.config.addChangeListener(changeEvent -> {
            for (String changedKey : changeEvent.changedKeys()) {
                if (!changedKey.startsWith("/shenyu/register/metadata")) continue;
                ConfigChange configChange = changeEvent.getChange(changedKey);
                this.publishMetadata(configChange.getNewValue());
            }
        }, null, Collections.singleton("/shenyu/register/metadata"));
    }

    private void subscribeUri() {
        this.config.addChangeListener(changeEvent -> {
            for (String changedKey : changeEvent.changedKeys()) {
                if (!changedKey.startsWith("/shenyu/register/uri")) continue;
                ConfigChange configChange = changeEvent.getChange(changedKey);
                switch (configChange.getChangeType()) {
                    case ADDED: 
                    case MODIFIED: {
                        this.publishRegisterURI(configChange.getNewValue());
                        break;
                    }
                    case DELETED: {
                        this.publishUnRegisterURI(configChange.getOldValue());
                        break;
                    }
                }
            }
        }, null, Collections.singleton("/shenyu/register/uri"));
    }

    private void publishMetadata(String metadata) {
        this.publisher.publish((Collection)Lists.newArrayList((Object[])new MetaDataRegisterDTO[]{(MetaDataRegisterDTO)GsonUtils.getInstance().fromJson(metadata, MetaDataRegisterDTO.class)}));
    }

    private void publishRegisterURI(String uriMetadata) {
        this.publisher.publish((Collection)Lists.newArrayList((Object[])new URIRegisterDTO[]{(URIRegisterDTO)GsonUtils.getInstance().fromJson(uriMetadata, URIRegisterDTO.class)}));
    }

    private void publishUnRegisterURI(String uriMetadata) {
        URIRegisterDTO uriOffline = (URIRegisterDTO)GsonUtils.getInstance().fromJson(uriMetadata, URIRegisterDTO.class);
        uriOffline.setEventType(EventType.OFFLINE);
        this.publisher.publish((Collection)Lists.newArrayList((Object[])new URIRegisterDTO[]{uriOffline}));
    }

    public void close() {
        this.publisher.close();
    }
}

