/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.server.apollo;

import com.ctrip.framework.apollo.openapi.client.ApolloOpenApiClient;
import com.ctrip.framework.apollo.openapi.dto.NamespaceReleaseDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenItemDTO;
import java.util.Date;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.client.server.apollo.ApolloConfig;

public class ApolloClient {
    private static final String DEFAULT_USER = "apollo";
    private final ApolloConfig apolloConfig;
    private final ApolloOpenApiClient apolloOpenApiClient;

    public ApolloClient(ApolloConfig apolloConfig) {
        this.apolloConfig = apolloConfig;
        this.apolloOpenApiClient = ApolloOpenApiClient.newBuilder().withPortalUrl(apolloConfig.getPortalUrl()).withToken(apolloConfig.getToken()).build();
    }

    public String getItemValue(String key) {
        OpenItemDTO openItemDTO = this.apolloOpenApiClient.getItem(this.apolloConfig.getAppId(), this.apolloConfig.getEnv(), this.apolloConfig.getClusterName(), this.apolloConfig.getNamespace(), key);
        if (openItemDTO == null) {
            return null;
        }
        if ("timeout".equals(openItemDTO.getKey())) {
            return null;
        }
        return openItemDTO.getValue();
    }

    public void createOrUpdateItem(String key, Object value, String comment) {
        this.createOrUpdateItem(key, GsonUtils.getInstance().toJson(value), comment);
    }

    public void createOrUpdateItem(String key, String value, String comment) {
        OpenItemDTO openItemDTO = new OpenItemDTO();
        openItemDTO.setKey(key);
        openItemDTO.setValue(value);
        openItemDTO.setComment(comment);
        openItemDTO.setDataChangeCreatedBy(DEFAULT_USER);
        openItemDTO.setDataChangeLastModifiedBy(DEFAULT_USER);
        Date now = new Date();
        openItemDTO.setDataChangeCreatedTime(now);
        openItemDTO.setDataChangeLastModifiedTime(now);
        this.apolloOpenApiClient.createOrUpdateItem(this.apolloConfig.getAppId(), this.apolloConfig.getEnv(), this.apolloConfig.getClusterName(), this.apolloConfig.getNamespace(), openItemDTO);
    }

    public void removeItem(String key) {
        this.apolloOpenApiClient.removeItem(this.apolloConfig.getAppId(), this.apolloConfig.getEnv(), this.apolloConfig.getClusterName(), this.apolloConfig.getNamespace(), key, DEFAULT_USER);
    }

    public void publishNamespace(String releaseTitle, String releaseComment) {
        NamespaceReleaseDTO namespaceReleaseDTO = new NamespaceReleaseDTO();
        namespaceReleaseDTO.setReleaseTitle(releaseTitle);
        namespaceReleaseDTO.setReleaseComment(releaseComment);
        namespaceReleaseDTO.setReleasedBy(DEFAULT_USER);
        this.apolloOpenApiClient.publishNamespace(this.apolloConfig.getAppId(), this.apolloConfig.getEnv(), this.apolloConfig.getClusterName(), this.apolloConfig.getNamespace(), namespaceReleaseDTO);
    }
}

