/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.elasticsearch.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.logging.elasticsearch.client.ElasticSearchLogCollectClient;
import org.apache.shenyu.plugin.logging.elasticsearch.collector.ElasticSearchLogCollector;
import org.apache.shenyu.plugin.logging.elasticsearch.config.ElasticSearchLogCollectConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingElasticSearchPluginDataHandler
implements PluginDataHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingElasticSearchPluginDataHandler.class);
    private static final ElasticSearchLogCollectClient ELASTICSEARCH_LOG_COLLECT_CLIENT = new ElasticSearchLogCollectClient();
    private static final String EMPTY_JSON = "{}";
    private static final Map<String, List<String>> SELECT_ID_URI_LIST_MAP = new ConcurrentHashMap<String, List<String>>();
    private static final Map<String, ElasticSearchLogCollectConfig.LogApiConfig> SELECT_API_CONFIG_MAP = new ConcurrentHashMap<String, ElasticSearchLogCollectConfig.LogApiConfig>();

    public void handlerPlugin(PluginData pluginData) {
        LOG.info("handler loggingElasticSearch Plugin data:{}", (Object)GsonUtils.getGson().toJson((Object)pluginData));
        if (pluginData.getEnabled().booleanValue()) {
            ElasticSearchLogCollectConfig.ElasticSearchLogConfig globalLogConfig = (ElasticSearchLogCollectConfig.ElasticSearchLogConfig)((Object)GsonUtils.getInstance().fromJson(pluginData.getConfig(), ElasticSearchLogCollectConfig.ElasticSearchLogConfig.class));
            ElasticSearchLogCollectConfig.INSTANCE.setElasticSearchLogConfig(globalLogConfig);
            Properties properties = new Properties();
            properties.setProperty("Host", globalLogConfig.getHost());
            properties.setProperty("port", globalLogConfig.getPort());
            ELASTICSEARCH_LOG_COLLECT_CLIENT.initClient(properties);
            ElasticSearchLogCollector.getInstance().start();
        } else {
            try {
                ElasticSearchLogCollector.getInstance().close();
            }
            catch (Exception e) {
                LOG.error("close log collector error", (Throwable)e);
            }
        }
    }

    public void handlerSelector(SelectorData selectorData) {
        LOG.info("handler loggingElasticSearch selector data:{}", (Object)GsonUtils.getGson().toJson((Object)selectorData));
        String handleJson = selectorData.getHandle();
        if (StringUtils.isEmpty((CharSequence)handleJson) || EMPTY_JSON.equals(handleJson.trim())) {
            return;
        }
        if (selectorData.getType().intValue() != SelectorTypeEnum.CUSTOM_FLOW.getCode() || CollectionUtils.isEmpty((Collection)selectorData.getConditionList())) {
            return;
        }
        ElasticSearchLogCollectConfig.LogApiConfig logApiConfig = (ElasticSearchLogCollectConfig.LogApiConfig)GsonUtils.getInstance().fromJson(handleJson, ElasticSearchLogCollectConfig.LogApiConfig.class);
        if (StringUtils.isBlank((CharSequence)logApiConfig.getIndex()) || StringUtils.isBlank((CharSequence)logApiConfig.getSampleRate())) {
            return;
        }
        ArrayList<String> uriList = new ArrayList<String>();
        for (ConditionData conditionData : selectorData.getConditionList()) {
            if (!"uri".equals(conditionData.getParamType()) || !StringUtils.isNotBlank((CharSequence)conditionData.getParamValue()) || !"match".equals(conditionData.getOperator()) && !"=".equals(conditionData.getOperator())) continue;
            uriList.add(conditionData.getParamValue().trim());
        }
        SELECT_ID_URI_LIST_MAP.put(selectorData.getId(), uriList);
        SELECT_API_CONFIG_MAP.put(selectorData.getId(), logApiConfig);
    }

    public void removeSelector(SelectorData selectorData) {
        LOG.info("handler remove loggingElasticSearch selector data:{}", (Object)GsonUtils.getGson().toJson((Object)selectorData));
        SELECT_ID_URI_LIST_MAP.remove(selectorData.getId());
        SELECT_API_CONFIG_MAP.remove(selectorData.getId());
    }

    public String pluginNamed() {
        return PluginEnum.LOGGING_ELASTIC_SEARCH.getName();
    }

    public static ElasticSearchLogCollectClient getElasticSearchLogCollectClient() {
        return ELASTICSEARCH_LOG_COLLECT_CLIENT;
    }

    public static Map<String, List<String>> getSelectIdUriListMap() {
        return SELECT_ID_URI_LIST_MAP;
    }

    public static Map<String, ElasticSearchLogCollectConfig.LogApiConfig> getSelectApiConfigMap() {
        return SELECT_API_CONFIG_MAP;
    }
}

