/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.divide.handler;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.DivideRuleHandle;
import org.apache.shenyu.common.dto.convert.selector.DivideUpstream;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.loadbalancer.cache.UpstreamCacheManager;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.cache.MetaDataCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.BeanHolder;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.springframework.util.ObjectUtils;

public class DividePluginDataHandler
implements PluginDataHandler {
    public static final Supplier<CommonHandleCache<String, DivideRuleHandle>> CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);

    public void handlerSelector(SelectorData selectorData) {
        if (Objects.isNull(selectorData) || Objects.isNull(selectorData.getId())) {
            return;
        }
        List upstreamList = GsonUtils.getInstance().fromList(selectorData.getHandle(), DivideUpstream.class);
        UpstreamCacheManager.getInstance().submit(selectorData.getId(), this.convertUpstreamList(upstreamList));
        MetaDataCache.getInstance().clean();
        if (!selectorData.getContinued().booleanValue()) {
            CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(selectorData.getId(), "default_rule"), (Object)DivideRuleHandle.newInstance());
        }
    }

    public void removeSelector(SelectorData selectorData) {
        UpstreamCacheManager.getInstance().removeByKey(selectorData.getId());
        MetaDataCache.getInstance().clean();
        CACHED_HANDLE.get().removeHandle((Object)CacheKeyUtils.INST.getKey(selectorData.getId(), "default_rule"));
    }

    public void handlerRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> {
            DivideRuleHandle divideRuleHandle = (DivideRuleHandle)GsonUtils.getInstance().fromJson(s, DivideRuleHandle.class);
            CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(ruleData), (Object)divideRuleHandle);
            MetaDataCache.getInstance().clean();
        });
    }

    public void removeRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> CACHED_HANDLE.get().removeHandle((Object)CacheKeyUtils.INST.getKey(ruleData)));
        MetaDataCache.getInstance().clean();
    }

    public String pluginNamed() {
        return PluginEnum.DIVIDE.getName();
    }

    private List<Upstream> convertUpstreamList(List<DivideUpstream> upstreamList) {
        if (ObjectUtils.isEmpty(upstreamList)) {
            return Collections.emptyList();
        }
        return upstreamList.stream().map(u -> Upstream.builder().protocol(u.getProtocol()).url(u.getUpstreamUrl()).weight(u.getWeight()).status(u.isStatus()).timestamp(u.getTimestamp()).warmup(u.getWarmup()).build()).collect(Collectors.toList());
    }
}

