/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.api.utils;

import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.utils.RequestQueryCodecUtil;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;

public final class RequestUrlUtils {
    private RequestUrlUtils() {
    }

    public static URI buildRequestUri(ServerWebExchange exchange, String domain) {
        String path = domain;
        String rewriteUri = (String)exchange.getAttributes().get("rewrite_uri");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rewriteUri})) {
            path = path + rewriteUri;
        } else {
            ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
            assert (shenyuContext != null);
            String realUrl = shenyuContext.getRealUrl();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{realUrl})) {
                path = path + realUrl;
            }
        }
        URI uri = exchange.getRequest().getURI();
        if (StringUtils.isNotEmpty((CharSequence)uri.getRawQuery()) && uri.getRawQuery().contains("%") || StringUtils.isNotEmpty((CharSequence)uri.getRawPath()) && uri.getRawPath().contains("%")) {
            path = path + "?" + RequestQueryCodecUtil.getCodecQuery(exchange);
            return UriComponentsBuilder.fromUriString((String)path).build(true).toUri();
        }
        if (StringUtils.isNotEmpty((CharSequence)uri.getQuery())) {
            path = path + "?" + uri.getQuery();
        }
        assert (path != null);
        return UriComponentsBuilder.fromUriString((String)path).build(false).toUri();
    }
}

