/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.validation.validator;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.shenyu.admin.spring.SpringBeanUtils;
import org.apache.shenyu.admin.utils.Assert;
import org.apache.shenyu.admin.validation.ExistProvider;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.apache.shenyu.common.utils.ReflectUtils;

public class ExistedValidator
implements ConstraintValidator<Existed, Serializable> {
    private Existed annotation;
    private final Map<String, ExistProvider> providerCacheMap = new ConcurrentHashMap<String, ExistProvider>();

    public void initialize(Existed constraintAnnotation) {
        this.annotation = constraintAnnotation;
    }

    public boolean isValid(Serializable value, ConstraintValidatorContext context) {
        Assert.notNull(this.annotation.provider(), "the validation ExistProvider is not found");
        if (this.annotation.nullOfIgnore() && Objects.isNull(value)) {
            return true;
        }
        if (this.annotation.reverse()) {
            return this.doValid(value) == false;
        }
        return this.doValid(value);
    }

    private ExistProvider getExistProvider() {
        ExistProvider provider = this.providerCacheMap.get(this.annotation.provider().getName());
        if (!Objects.isNull(provider)) {
            return provider;
        }
        provider = SpringBeanUtils.getInstance().getBean(this.annotation.provider());
        this.providerCacheMap.put(this.annotation.provider().getName(), provider);
        return provider;
    }

    private Boolean doValid(Serializable value) {
        ExistProvider provider = this.getExistProvider();
        if (!"existed".equals(this.annotation.providerMethodName())) {
            return Boolean.TRUE.equals(ReflectUtils.invokeMethod((Object)provider, (String)this.annotation.providerMethodName(), Assert::throwException, (Object[])new Object[]{value}));
        }
        return Boolean.TRUE.equals(this.getExistProvider().existed(value));
    }
}

