/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.publish;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.mapper.RuleConditionMapper;
import org.apache.shenyu.admin.mapper.RuleMapper;
import org.apache.shenyu.admin.model.dto.RuleConditionDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.entity.RuleConditionDO;
import org.apache.shenyu.admin.model.entity.RuleDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.AdminDataModelChangedEvent;
import org.apache.shenyu.admin.model.event.rule.BatchRuleDeletedEvent;
import org.apache.shenyu.admin.model.event.rule.RuleChangedEvent;
import org.apache.shenyu.admin.model.event.rule.RuleCreatedEvent;
import org.apache.shenyu.admin.model.event.rule.RuleUpdatedEvent;
import org.apache.shenyu.admin.model.event.selector.BatchSelectorDeletedEvent;
import org.apache.shenyu.admin.service.publish.AdminDataModelChangedEventPublisher;
import org.apache.shenyu.admin.transfer.ConditionTransfer;
import org.apache.shenyu.admin.utils.ListUtil;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class RuleEventPublisher
implements AdminDataModelChangedEventPublisher<RuleDO> {
    private final ApplicationEventPublisher publisher;
    private final RuleConditionMapper ruleConditionMapper;
    private final RuleMapper ruleMapper;

    public RuleEventPublisher(ApplicationEventPublisher publisher, RuleConditionMapper ruleConditionMapper, PluginMapper pluginMapper, RuleMapper ruleMapper) {
        this.publisher = publisher;
        this.ruleConditionMapper = ruleConditionMapper;
        this.ruleMapper = ruleMapper;
    }

    @Override
    public void onCreated(RuleDO rule) {
        this.publish(new RuleCreatedEvent(rule, SessionUtil.visitorName()));
    }

    public void onCreated(RuleDO rule, List<RuleConditionDTO> condition) {
        this.publish(new RuleCreatedEvent(rule, SessionUtil.visitorName()));
        this.publishEvent(rule, condition);
    }

    public void onUpdated(RuleDO rule, RuleDO before, List<RuleConditionDTO> condition) {
        this.publish(new RuleUpdatedEvent(rule, before, SessionUtil.visitorName()));
        this.publishEvent(rule, condition);
    }

    @Override
    public void onUpdated(RuleDO rule, RuleDO before) {
        this.publish(new RuleUpdatedEvent(rule, before, SessionUtil.visitorName()));
    }

    @Override
    public void onDeleted(RuleDO rule) {
        this.publish(new RuleChangedEvent(rule, null, EventTypeEnum.RULE_DELETE, SessionUtil.visitorName()));
    }

    @Override
    public void onDeleted(Collection<RuleDO> rules) {
        this.publish(new BatchRuleDeletedEvent(rules, SessionUtil.visitorName(), null));
        List<RuleConditionDO> condition = this.ruleConditionMapper.selectByRuleIdSet(rules.stream().map(BaseDO::getId).collect(Collectors.toSet()));
        Map<String, List<RuleConditionDO>> conditionsRuleGroup = ListUtil.groupBy(condition, RuleConditionDO::getRuleId);
        List<RuleData> ruleData = ListUtil.map(rules, r -> RuleDO.transFrom(r, this.ruleMapper.getPluginNameBySelectorId(r.getSelectorId()), ListUtil.map((Collection)conditionsRuleGroup.get(r.getId()), ConditionTransfer.INSTANCE::mapToRuleDO)));
        this.publisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.RULE, DataEventTypeEnum.DELETE, ruleData));
    }

    public void onDeleted(List<RuleDO> rules, BatchSelectorDeletedEvent event) {
        this.publish(new BatchRuleDeletedEvent(rules, SessionUtil.visitorName(), null));
        List<RuleConditionDO> condition = this.ruleConditionMapper.selectByRuleIdSet(rules.stream().map(BaseDO::getId).collect(Collectors.toSet()));
        Map<String, List<RuleConditionDO>> conditionsRuleGroup = ListUtil.groupBy(condition, RuleConditionDO::getRuleId);
        List<RuleData> ruleData = ListUtil.map(rules, r -> RuleDO.transFrom(r, Optional.ofNullable(event.findPluginBySelectorId(r.getSelectorId())).map(PluginDO::getName).orElse(null), ListUtil.map((Collection)conditionsRuleGroup.get(r.getId()), ConditionTransfer.INSTANCE::mapToRuleDO)));
        this.publisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.RULE, DataEventTypeEnum.DELETE, ruleData));
    }

    public void onRegister(RuleDO rule, List<RuleConditionDTO> condition) {
        this.publishEvent(rule, condition);
    }

    @Override
    public void publish(AdminDataModelChangedEvent event) {
        this.publisher.publishEvent((ApplicationEvent)event);
    }

    private void publishEvent(RuleDO ruleDO, List<RuleConditionDTO> condition) {
        RuleData rule = RuleDO.transFrom(ruleDO, this.ruleMapper.getPluginNameBySelectorId(ruleDO.getSelectorId()), ListUtil.map(condition, ConditionTransfer.INSTANCE::mapToRuleDTO));
        this.publisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.RULE, DataEventTypeEnum.UPDATE, Collections.singletonList(rule)));
    }
}

