/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.manager.impl;

import com.alibaba.nacos.shaded.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.model.bean.UpstreamInstance;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.SelectorQuery;
import org.apache.shenyu.admin.model.vo.SelectorVO;
import org.apache.shenyu.admin.model.vo.ShenyuDictVO;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.admin.service.ShenyuDictService;
import org.apache.shenyu.admin.service.converter.SelectorHandleConverterFactor;
import org.apache.shenyu.admin.service.manager.LoadServiceDocEntry;
import org.apache.shenyu.admin.service.manager.ServiceDocManager;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.selector.CommonUpstream;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.common.utils.PluginNameAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LoadServiceDocEntryImpl
implements LoadServiceDocEntry {
    private static final Logger LOG = LoggerFactory.getLogger(LoadServiceDocEntryImpl.class);
    private static Map<String, String> supportSwaggerPluginMap = Collections.EMPTY_MAP;
    private final SelectorService selectorService;
    private final SelectorHandleConverterFactor converterFactor;
    private final PluginMapper pluginMapper;
    private final ServiceDocManager serviceDocManager;
    private final ShenyuDictService shenyuDictService;

    public LoadServiceDocEntryImpl(SelectorService selectorService, SelectorHandleConverterFactor converterFactor, PluginMapper pluginMapper, ServiceDocManager serviceDocManager, ShenyuDictService shenyuDictService) {
        this.selectorService = selectorService;
        this.converterFactor = converterFactor;
        this.pluginMapper = pluginMapper;
        this.serviceDocManager = serviceDocManager;
        this.shenyuDictService = shenyuDictService;
    }

    @Override
    public synchronized void loadApiDocument() {
        if (!this.isEnabledLoad()) {
            return;
        }
        List<UpstreamInstance> serviceList = this.getAllClusterLastUpdateInstanceList();
        if (CollectionUtils.isEmpty(serviceList)) {
            LOG.info("load api document No service registered.");
            return;
        }
        HashSet<UpstreamInstance> currentServices = new HashSet<UpstreamInstance>(serviceList);
        LOG.info("load api document  serviceList={}", (Object)JsonUtils.toJson(currentServices));
        this.serviceDocManager.pullApiDocument(currentServices);
    }

    @Override
    public void loadDocOnSelectorChanged(List<SelectorData> changedList, DataEventTypeEnum eventType) {
        if (Objects.nonNull(eventType) && (eventType == DataEventTypeEnum.CREATE || eventType == DataEventTypeEnum.UPDATE)) {
            List<UpstreamInstance> serviceList = this.getLastUpdateInstanceList(changedList);
            if (CollectionUtils.isEmpty(serviceList)) {
                LOG.info("load api document, no service registered.");
                return;
            }
            if (!this.isEnabledLoad()) {
                return;
            }
            HashSet<UpstreamInstance> currentServices = new HashSet<UpstreamInstance>(serviceList);
            LOG.info("loadDocOnSelectorChanged serviceList={}", (Object)JsonUtils.toJson(currentServices));
            this.serviceDocManager.pullApiDocument(currentServices);
        }
    }

    private boolean isEnabledLoad() {
        ShenyuDictVO shenyuInitData = this.shenyuDictService.findByDictCodeName("API_DOC_GLOBAL_FLAG", "status");
        if (Objects.nonNull(shenyuInitData) && Boolean.TRUE.toString().equals(shenyuInitData.getDictValue())) {
            return true;
        }
        LOG.info("load api document global switch is close.");
        return false;
    }

    private List<UpstreamInstance> getLastUpdateInstanceList(List<SelectorData> changedList) {
        if (CollectionUtils.isEmpty(changedList)) {
            LOG.info("getLastUpdateInstanceList, changedList is empty.");
            return Collections.EMPTY_LIST;
        }
        return changedList.parallelStream().map(this::getClusterLastUpdateInstance).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<UpstreamInstance> getAllClusterLastUpdateInstanceList() {
        ArrayList<String> pluginNames = new ArrayList<String>();
        RpcTypeEnum.acquireSupportSwaggers().forEach(rpcTypeEnum -> pluginNames.add(PluginNameAdapter.rpcTypeAdapter((String)rpcTypeEnum.getName())));
        List<PluginDO> pluginDOList = this.pluginMapper.selectByNames(pluginNames);
        if (CollectionUtils.isEmpty(pluginDOList)) {
            return Collections.EMPTY_LIST;
        }
        supportSwaggerPluginMap = pluginDOList.stream().filter(Objects::nonNull).collect(Collectors.toMap(BaseDO::getId, PluginDO::getName, (value1, value2) -> value1));
        CommonPager<SelectorVO> commonPager = this.selectorService.listByPage(new SelectorQuery(Lists.newArrayList(supportSwaggerPluginMap.keySet()), null, new PageParameter(1, Integer.MAX_VALUE)));
        List<SelectorVO> clusterList = commonPager.getDataList();
        if (CollectionUtils.isEmpty(clusterList)) {
            LOG.info("getAllClusterLastUpdateInstanceList, Not loaded into available backend services.");
            return Collections.EMPTY_LIST;
        }
        return clusterList.parallelStream().map(this::getClusterLastUpdateInstance).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private UpstreamInstance getClusterLastUpdateInstance(SelectorVO selectorVO) {
        List<UpstreamInstance> allInstances = this.getInstances(selectorVO.getPluginId(), selectorVO.getHandle(), selectorVO.getName(), selectorVO.getEnabled());
        if (CollectionUtils.isEmpty(allInstances)) {
            return null;
        }
        return this.getClusterLastUpdateInstance(allInstances);
    }

    private UpstreamInstance getClusterLastUpdateInstance(SelectorData selectorData) {
        if (!supportSwaggerPluginMap.containsKey(selectorData.getPluginId())) {
            LOG.info("getClusterLastUpdateInstance. pluginNae={} does not support pulling API documents.", (Object)selectorData.getPluginName());
            return null;
        }
        List<UpstreamInstance> allInstances = this.getInstances(selectorData.getPluginId(), selectorData.getHandle(), selectorData.getName(), selectorData.getEnabled());
        if (Objects.isNull(allInstances)) {
            return null;
        }
        return this.getClusterLastUpdateInstance(allInstances);
    }

    private UpstreamInstance getClusterLastUpdateInstance(List<UpstreamInstance> allInstances) {
        if (CollectionUtils.isEmpty(allInstances)) {
            return null;
        }
        return allInstances.stream().filter(Objects::nonNull).filter(UpstreamInstance::isHealthy).max(Comparator.comparing(UpstreamInstance::getStartupTime)).orElse(null);
    }

    private List<UpstreamInstance> getInstances(String pluginId, String handle, String contextPath, boolean enabled) {
        ArrayList<UpstreamInstance> allInstances = null;
        if (StringUtils.isNotEmpty((CharSequence)handle)) {
            allInstances = new ArrayList<UpstreamInstance>();
            try {
                List<CommonUpstream> upstreamList = this.convert(pluginId, handle);
                for (CommonUpstream upstream : upstreamList) {
                    UpstreamInstance instance = new UpstreamInstance();
                    instance.setContextPath(contextPath);
                    String[] upstreamUrlArr = upstream.getUpstreamUrl().split(":");
                    instance.setIp(upstreamUrlArr[0]);
                    instance.setPort(upstreamUrlArr.length == 1 ? 80 : Integer.parseInt(upstreamUrlArr[1]));
                    instance.setEnabled(enabled);
                    instance.setHealthy(true);
                    instance.setStartupTime(upstream.getTimestamp());
                    allInstances.add(instance);
                }
            }
            catch (Exception e) {
                LOG.error("Error getting cluster instance list. contextPath={} error={}", (Object)contextPath, (Object)e);
                return null;
            }
        }
        return allInstances;
    }

    private List<CommonUpstream> convert(String pluginId, String handle) {
        String pluginName = supportSwaggerPluginMap.get(pluginId);
        return this.converterFactor.newInstance(pluginName).convertUpstream(handle).stream().filter(CommonUpstream::isStatus).collect(Collectors.toList());
    }
}

