/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.manager.impl;

import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.bean.DocInfo;
import org.apache.shenyu.admin.model.bean.DocItem;
import org.apache.shenyu.admin.model.bean.DocModule;
import org.apache.shenyu.admin.service.manager.DocManager;
import org.apache.shenyu.admin.service.manager.DocParser;
import org.apache.shenyu.admin.service.manager.impl.SwaggerDocParser;
import org.apache.shenyu.common.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

@Service
public class DocManagerImpl
implements DocManager {
    private static final Logger LOG = LoggerFactory.getLogger(DocManagerImpl.class);
    private static final Map<String, DocInfo> DOC_DEFINITION_MAP = new HashMap<String, DocInfo>();
    private static final Map<String, String> CLUSTER_MD5_MAP = new HashMap<String, String>();
    private static final Map<String, DocItem> ITEM_DOC_MAP = new ConcurrentHashMap<String, DocItem>(256);
    private static final DocParser SWAGGER_DOC_PARSER = new SwaggerDocParser();

    @Override
    public void addDocInfo(String clusterName, String docInfoJson, Consumer<DocInfo> callback) {
        String oldMd5;
        if (StringUtils.isEmpty((CharSequence)docInfoJson)) {
            return;
        }
        String newMd5 = DigestUtils.md5DigestAsHex((byte[])docInfoJson.getBytes(StandardCharsets.UTF_8));
        if (Objects.equals(newMd5, oldMd5 = CLUSTER_MD5_MAP.get(clusterName))) {
            return;
        }
        CLUSTER_MD5_MAP.put(clusterName, newMd5);
        DocInfo docInfo = this.getDocInfo(clusterName, docInfoJson);
        if (Objects.isNull(docInfo) || CollectionUtils.isEmpty(docInfo.getDocModuleList())) {
            return;
        }
        List<DocModule> docModules = docInfo.getDocModuleList();
        DOC_DEFINITION_MAP.put(docInfo.getTitle(), docInfo);
        docModules.forEach(docModule -> docModule.getDocItems().forEach(docItem -> ITEM_DOC_MAP.put(docItem.getId(), (DocItem)docItem)));
        callback.accept(docInfo);
    }

    private DocInfo getDocInfo(String clusterName, String docInfoJson) {
        try {
            JsonObject docRoot = (JsonObject)GsonUtils.getInstance().fromJson(docInfoJson, JsonObject.class);
            docRoot.addProperty("basePath", "/" + clusterName);
            DocInfo docInfo = SWAGGER_DOC_PARSER.parseJson(docRoot);
            docInfo.setClusterName(clusterName);
            return docInfo;
        }
        catch (Exception e) {
            LOG.error("getDocInfo error={}", (Throwable)e);
            return null;
        }
    }

    @Override
    public DocInfo getByTitle(String title) {
        return DOC_DEFINITION_MAP.get(title);
    }

    @Override
    public DocItem getDocItem(String id) {
        return ITEM_DOC_MAP.get(id);
    }

    @Override
    public Collection<DocInfo> listAll() {
        return DOC_DEFINITION_MAP.values();
    }

    @Override
    public String getDocMd5(String clusterName) {
        return CLUSTER_MD5_MAP.get(clusterName);
    }

    @Override
    public void remove(String clusterName) {
        CLUSTER_MD5_MAP.remove(clusterName);
        DOC_DEFINITION_MAP.entrySet().removeIf(entry -> clusterName.equalsIgnoreCase(((DocInfo)entry.getValue()).getClusterName()));
    }
}

