/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.aspect.annotation.DataPermission;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.mapper.SelectorConditionMapper;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.dto.SelectorConditionDTO;
import org.apache.shenyu.admin.model.dto.SelectorDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.entity.SelectorConditionDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.model.event.plugin.BatchPluginDeletedEvent;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.SelectorConditionQuery;
import org.apache.shenyu.admin.model.query.SelectorQuery;
import org.apache.shenyu.admin.model.query.SelectorQueryCondition;
import org.apache.shenyu.admin.model.vo.SelectorConditionVO;
import org.apache.shenyu.admin.model.vo.SelectorVO;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.admin.service.publish.SelectorEventPublisher;
import org.apache.shenyu.admin.transfer.ConditionTransfer;
import org.apache.shenyu.admin.utils.ListUtil;
import org.apache.shenyu.admin.utils.SelectorUtil;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.common.utils.ContextPathUtils;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SelectorServiceImpl
implements SelectorService {
    private final SelectorMapper selectorMapper;
    private final SelectorConditionMapper selectorConditionMapper;
    private final PluginMapper pluginMapper;
    private final ApplicationEventPublisher eventPublisher;
    private final SelectorEventPublisher selectorEventPublisher;

    public SelectorServiceImpl(SelectorMapper selectorMapper, SelectorConditionMapper selectorConditionMapper, PluginMapper pluginMapper, ApplicationEventPublisher eventPublisher, SelectorEventPublisher selectorEventPublisher) {
        this.selectorMapper = selectorMapper;
        this.selectorConditionMapper = selectorConditionMapper;
        this.pluginMapper = pluginMapper;
        this.eventPublisher = eventPublisher;
        this.selectorEventPublisher = selectorEventPublisher;
    }

    @Override
    public List<SelectorVO> searchByCondition(SelectorQueryCondition condition) {
        condition.init();
        List<SelectorVO> list = this.selectorMapper.selectByCondition(condition);
        for (SelectorVO selector : list) {
            selector.setMatchModeName(MatchModeEnum.getMatchModeByCode((int)selector.getMatchMode()));
            selector.setTypeName(SelectorTypeEnum.getSelectorTypeByCode((int)selector.getType()));
        }
        return list;
    }

    @Override
    public String registerDefault(SelectorDTO selectorDTO) {
        SelectorDO selectorDO = SelectorDO.buildSelectorDO(selectorDTO);
        if (StringUtils.isEmpty((CharSequence)selectorDTO.getId())) {
            this.selectorMapper.insertSelective(selectorDO);
            this.createCondition(selectorDO.getId(), selectorDTO.getSelectorConditions());
        }
        this.publishEvent(selectorDO, selectorDTO.getSelectorConditions());
        return selectorDO.getId();
    }

    @Override
    public String registerDefault(MetaDataRegisterDTO dto, String pluginName, String selectorHandler) {
        String contextPath = ContextPathUtils.buildContextPath((String)dto.getContextPath(), (String)dto.getAppName());
        SelectorDO selectorDO = this.findByNameAndPluginName(contextPath, pluginName);
        if (Objects.isNull(selectorDO)) {
            SelectorDTO selectorDTO = SelectorUtil.buildSelectorDTO(contextPath, this.pluginMapper.selectByName(pluginName).getId());
            selectorDTO.setHandle(selectorHandler);
            return this.registerDefault(selectorDTO);
        }
        return selectorDO.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int createOrUpdate(SelectorDTO selectorDTO) {
        return SelectorService.super.createOrUpdate(selectorDTO);
    }

    @Override
    public int create(SelectorDTO selectorDTO) {
        SelectorDO selectorDO = SelectorDO.buildSelectorDO(selectorDTO);
        int selectorCount = this.selectorMapper.insertSelective(selectorDO);
        this.createCondition(selectorDO.getId(), selectorDTO.getSelectorConditions());
        this.publishEvent(selectorDO, selectorDTO.getSelectorConditions());
        if (selectorCount > 0) {
            this.selectorEventPublisher.onCreated(selectorDO);
        }
        return selectorCount;
    }

    @Override
    public int update(SelectorDTO selectorDTO) {
        SelectorDO before = this.selectorMapper.selectById(selectorDTO.getId());
        SelectorDO selectorDO = SelectorDO.buildSelectorDO(selectorDTO);
        int selectorCount = this.selectorMapper.updateSelective(selectorDO);
        this.selectorConditionMapper.deleteByQuery(new SelectorConditionQuery(selectorDO.getId()));
        this.createCondition(selectorDO.getId(), selectorDTO.getSelectorConditions());
        this.publishEvent(selectorDO, selectorDTO.getSelectorConditions());
        if (selectorCount > 0) {
            this.selectorEventPublisher.onUpdated(selectorDO, before);
        }
        return selectorCount;
    }

    @Override
    public int updateSelective(SelectorDO selectorDO) {
        return this.selectorMapper.updateSelective(selectorDO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int delete(List<String> ids) {
        List<SelectorDO> selectors = this.selectorMapper.selectByIdSet(new TreeSet<String>(ids));
        return this.deleteSelector(selectors, this.pluginMapper.selectByIds(ListUtil.map(selectors, SelectorDO::getPluginId)));
    }

    @Override
    public SelectorVO findById(String id) {
        List<SelectorConditionVO> conditions = ListUtil.map(this.selectorConditionMapper.selectByQuery(new SelectorConditionQuery(id)), SelectorConditionVO::buildSelectorConditionVO);
        return SelectorVO.buildSelectorVO(this.selectorMapper.selectById(id), conditions);
    }

    @Override
    public SelectorDO findByName(String name) {
        return this.selectorMapper.selectByName(name);
    }

    @Override
    public SelectorDO findByNameAndPluginName(String name, String pluginName) {
        PluginDO pluginDO = this.pluginMapper.selectByName(pluginName);
        return this.selectorMapper.findByNameAndPluginId(name, pluginDO.getId());
    }

    @Override
    public SelectorData buildByName(String name) {
        return this.buildSelectorData(this.selectorMapper.selectByName(name));
    }

    @Override
    public SelectorData buildByName(String name, String pluginName) {
        return this.buildSelectorData(this.findByNameAndPluginName(name, pluginName));
    }

    @Override
    @DataPermission(dataType="selector")
    @Pageable
    public CommonPager<SelectorVO> listByPageWithPermission(SelectorQuery selectorQuery) {
        return this.listByPage(selectorQuery);
    }

    @Override
    public CommonPager<SelectorVO> listByPage(SelectorQuery selectorQuery) {
        return PageResultUtils.result(selectorQuery.getPageParameter(), () -> this.selectorMapper.selectByQuery(selectorQuery).stream().map(SelectorVO::buildSelectorVO).collect(Collectors.toList()));
    }

    @Override
    public List<SelectorData> findByPluginId(String pluginId) {
        return this.buildSelectorDataList(this.selectorMapper.findByPluginId(pluginId));
    }

    @Override
    public List<SelectorData> listAll() {
        return this.buildSelectorDataList(this.selectorMapper.selectAll());
    }

    @EventListener(value={BatchPluginDeletedEvent.class})
    public void onPluginDeleted(BatchPluginDeletedEvent event) {
        this.deleteSelector(this.selectorMapper.findByPluginIds(event.getDeletedPluginIds()), event.getPlugins());
    }

    private void createCondition(String selectorId, List<SelectorConditionDTO> selectorConditions) {
        for (SelectorConditionDTO condition : selectorConditions) {
            condition.setSelectorId(selectorId);
            this.selectorConditionMapper.insertSelective(SelectorConditionDO.buildSelectorConditionDO(condition));
        }
    }

    private int deleteSelector(List<SelectorDO> selectors, List<PluginDO> plugins) {
        if (CollectionUtils.isNotEmpty(selectors)) {
            List<String> selectorIds = ListUtil.map(selectors, BaseDO::getId);
            int count = this.selectorMapper.deleteByIds(selectorIds);
            this.selectorConditionMapper.deleteBySelectorIds(selectorIds);
            if (count > 0) {
                this.selectorEventPublisher.onDeleted(selectors, plugins);
            }
            return count;
        }
        return selectors.size();
    }

    private void publishEvent(SelectorDO selectorDO, List<SelectorConditionDTO> selectorConditions) {
        PluginDO pluginDO = this.pluginMapper.selectById(selectorDO.getPluginId());
        List<ConditionData> conditionDataList = ListUtil.map(selectorConditions, ConditionTransfer.INSTANCE::mapToSelectorDTO);
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, DataEventTypeEnum.UPDATE, Collections.singletonList(SelectorDO.transFrom(selectorDO, pluginDO.getName(), conditionDataList))));
    }

    private SelectorData buildSelectorData(SelectorDO selectorDO) {
        List<ConditionData> conditionDataList = ConditionTransfer.INSTANCE.mapToSelectorDOS(this.selectorConditionMapper.selectByQuery(new SelectorConditionQuery(selectorDO.getId())));
        PluginDO pluginDO = this.pluginMapper.selectById(selectorDO.getPluginId());
        if (Objects.isNull(pluginDO)) {
            return null;
        }
        return SelectorDO.transFrom(selectorDO, pluginDO.getName(), conditionDataList);
    }

    private List<SelectorData> buildSelectorDataList(List<SelectorDO> selectorDOList) {
        Map<String, String> idMap = ListUtil.toMap(selectorDOList, BaseDO::getId, SelectorDO::getPluginId);
        if (MapUtils.isEmpty(idMap)) {
            return new ArrayList<SelectorData>();
        }
        Map<String, List<SelectorConditionDO>> selectorConditionMap = ListUtil.groupBy(this.selectorConditionMapper.selectBySelectorIds(idMap.keySet()), SelectorConditionDO::getSelectorId);
        Map<String, PluginDO> pluginDOMap = ListUtil.toMap(this.pluginMapper.selectByIds(Lists.newArrayList(idMap.values())), BaseDO::getId);
        return Optional.ofNullable(selectorDOList).orElseGet(ArrayList::new).stream().filter(Objects::nonNull).map(selectorDO -> {
            String id = selectorDO.getId();
            String pluginId = selectorDO.getPluginId();
            PluginDO pluginDO = (PluginDO)pluginDOMap.get(pluginId);
            if (Objects.isNull(pluginDO)) {
                return null;
            }
            List<ConditionData> conditionDataList = ConditionTransfer.INSTANCE.mapToSelectorDOS((List)selectorConditionMap.get(id));
            return SelectorDO.transFrom(selectorDO, pluginDO.getName(), conditionDataList);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

