/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.SelectorDTO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.query.SelectorQuery;
import org.apache.shenyu.admin.model.query.SelectorQueryCondition;
import org.apache.shenyu.admin.model.vo.SelectorVO;
import org.apache.shenyu.admin.service.PageService;
import org.apache.shenyu.admin.utils.Assert;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;

public interface SelectorService
extends PageService<SelectorQueryCondition, SelectorVO> {
    public String registerDefault(SelectorDTO var1);

    public String registerDefault(MetaDataRegisterDTO var1, String var2, String var3);

    default public int createOrUpdate(SelectorDTO selectorDTO) {
        if (Objects.equals(SelectorTypeEnum.CUSTOM_FLOW.getCode(), selectorDTO.getType())) {
            Assert.notNull(selectorDTO.getMatchMode(), "if type is custom, matchMode is not null");
            Assert.notEmpty(selectorDTO.getSelectorConditions(), "if type is custom, selectorConditions is not empty");
            selectorDTO.getSelectorConditions().forEach(selectorConditionDTO -> {
                Assert.notBlack(selectorConditionDTO.getParamType(), "if type is custom, paramType is not empty");
                Assert.notBlack(selectorConditionDTO.getParamName(), "if type is custom, paramName is not empty");
                Assert.notBlack(selectorConditionDTO.getParamValue(), "if type is custom, paramValue is not empty");
            });
        }
        return StringUtils.isEmpty((CharSequence)selectorDTO.getId()) ? this.create(selectorDTO) : this.update(selectorDTO);
    }

    public int create(SelectorDTO var1);

    public int update(SelectorDTO var1);

    public int updateSelective(SelectorDO var1);

    public int delete(List<String> var1);

    public SelectorVO findById(String var1);

    public SelectorDO findByName(String var1);

    public SelectorDO findByNameAndPluginName(String var1, String var2);

    public SelectorData buildByName(String var1);

    public SelectorData buildByName(String var1, String var2);

    public CommonPager<SelectorVO> listByPageWithPermission(SelectorQuery var1);

    public CommonPager<SelectorVO> listByPage(SelectorQuery var1);

    public List<SelectorData> findByPluginId(String var1);

    public List<SelectorData> listAll();
}

