/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.vo;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import org.apache.shenyu.admin.model.entity.RoleDO;
import org.apache.shenyu.common.utils.DateUtils;

public class RoleVO
implements Serializable {
    private static final long serialVersionUID = 2783609252111382305L;
    private String id;
    private String roleName;
    private String description;
    private String dateCreated;
    private String dateUpdated;

    public RoleVO() {
    }

    public RoleVO(String id, String roleName, String description, String dateCreated, String dateUpdated) {
        this.id = id;
        this.roleName = roleName;
        this.description = description;
        this.dateCreated = dateCreated;
        this.dateUpdated = dateUpdated;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(String dateCreated) {
        this.dateCreated = dateCreated;
    }

    public String getDateUpdated() {
        return this.dateUpdated;
    }

    public void setDateUpdated(String dateUpdated) {
        this.dateUpdated = dateUpdated;
    }

    public static RoleVO buildRoleVO(RoleDO roleDO) {
        return Optional.ofNullable(roleDO).map(item -> new RoleVO(item.getId(), item.getRoleName(), item.getDescription(), DateUtils.localDateTimeToString((LocalDateTime)item.getDateCreated().toLocalDateTime()), DateUtils.localDateTimeToString((LocalDateTime)item.getDateUpdated().toLocalDateTime()))).orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoleVO)) {
            return false;
        }
        RoleVO roleVO = (RoleVO)o;
        return Objects.equals(this.id, roleVO.id) && Objects.equals(this.roleName, roleVO.roleName) && Objects.equals(this.description, roleVO.description) && Objects.equals(this.dateCreated, roleVO.dateCreated) && Objects.equals(this.dateUpdated, roleVO.dateUpdated);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.roleName, this.description, this.dateCreated, this.dateUpdated);
    }

    public String toString() {
        return "RoleVO{id='" + this.id + '\'' + ", roleName='" + this.roleName + '\'' + ", description='" + this.description + '\'' + ", dateCreated='" + this.dateCreated + '\'' + ", dateUpdated='" + this.dateUpdated + '\'' + '}';
    }
}

