/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.event.user;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.entity.DashboardUserDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.AdminDataModelChangedEvent;

public class UserChangedEvent
extends AdminDataModelChangedEvent {
    public UserChangedEvent(DashboardUserDO source, DashboardUserDO before, EventTypeEnum type, String operator) {
        super(source, before, type, operator);
    }

    @Override
    public String buildContext() {
        DashboardUserDO after = (DashboardUserDO)this.getAfter();
        if (Objects.isNull(this.getBefore())) {
            return String.format("the selector [%s] is %s", after.getUserName(), StringUtils.lowerCase((String)this.getType().getType().toString()));
        }
        return String.format("the selector [%s] is %s : %s", after.getUserName(), StringUtils.lowerCase((String)this.getType().getType().toString()), this.contrast());
    }

    public DashboardUserDO getChangedUser() {
        return (DashboardUserDO)this.getSource();
    }

    private String contrast() {
        DashboardUserDO before = (DashboardUserDO)this.getBefore();
        Objects.requireNonNull(before);
        DashboardUserDO after = (DashboardUserDO)this.getAfter();
        Objects.requireNonNull(after);
        if (Objects.equals(before, after)) {
            return "it no change";
        }
        StringBuilder builder = new StringBuilder();
        if (!Objects.equals(before.getUserName(), after.getUserName())) {
            builder.append(String.format("name[%s => %s] ", before.getUserName(), after.getUserName()));
        }
        if (!Objects.equals(before.getPassword(), after.getPassword())) {
            builder.append("password is changed...");
        }
        if (!Objects.equals(before.getRole(), after.getRole())) {
            builder.append(String.format("role[%s => %s] ", before.getRole(), after.getRole()));
        }
        if (!Objects.equals(before.getEnabled(), after.getEnabled())) {
            builder.append(String.format("enable[%s => %s] ", before.getEnabled(), after.getEnabled()));
        }
        return builder.toString();
    }

    @Override
    public String eventName() {
        return "user";
    }
}

