/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.event.role;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.RoleDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.BatchChangedEvent;
import org.apache.shenyu.admin.utils.ListUtil;

public class BatchRoleDeletedEvent
extends BatchChangedEvent {
    private final List<String> deletedIds;

    public BatchRoleDeletedEvent(Collection<RoleDO> source, String operator) {
        super(source, null, EventTypeEnum.ROLE_DELETE, operator);
        this.deletedIds = ListUtil.map(source, BaseDO::getId);
    }

    @Override
    public String buildContext() {
        String selector = ((Collection)this.getSource()).stream().map(s -> ((RoleDO)s).getRoleName()).collect(Collectors.joining(","));
        return String.format("the role[%s] is %s", selector, StringUtils.lowerCase((String)this.getType().getType().toString()));
    }

    public List<RoleDO> getRoles() {
        return ((Collection)this.getSource()).stream().map(RoleDO.class::cast).collect(Collectors.toList());
    }

    public List<String> getDeletedIds() {
        return this.deletedIds;
    }
}

