/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.event.handle;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.entity.PluginHandleDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.AdminDataModelChangedEvent;

public class PluginHandleChangedEvent
extends AdminDataModelChangedEvent {
    public PluginHandleChangedEvent(PluginHandleDO source, PluginHandleDO before, EventTypeEnum type, String operator) {
        super(source, before, type, operator);
    }

    @Override
    public String buildContext() {
        PluginHandleDO after = (PluginHandleDO)this.getAfter();
        if (Objects.isNull(this.getBefore())) {
            return String.format("the plugin-handle [%s] is %s", after.getField(), StringUtils.lowerCase((String)this.getType().getType().toString()));
        }
        return String.format("the plugin-handle [%s] is %s : %s", after.getField(), StringUtils.lowerCase((String)this.getType().getType().toString()), this.contrast());
    }

    private String contrast() {
        PluginHandleDO before = (PluginHandleDO)this.getBefore();
        Objects.requireNonNull(before);
        PluginHandleDO after = (PluginHandleDO)this.getAfter();
        Objects.requireNonNull(after);
        if (Objects.equals(before, after)) {
            return "it no change";
        }
        StringBuilder builder = new StringBuilder();
        if (!Objects.equals(before.getField(), after.getField())) {
            builder.append(String.format("field[%s => %s] ", before.getField(), after.getField()));
        }
        if (!Objects.equals(before.getLabel(), after.getLabel())) {
            builder.append(String.format("label[%s => %s] ", before.getLabel(), after.getLabel()));
        }
        if (!Objects.equals(before.getType(), after.getType())) {
            builder.append(String.format("type[%s => %s] ", before.getType(), after.getType()));
        }
        if (!Objects.equals(before.getDataType(), after.getDataType())) {
            builder.append(String.format("dataType[%s => %s] ", before.getDateCreated(), after.getDataType()));
        }
        if (!Objects.equals(before.getSort(), after.getSort())) {
            builder.append(String.format("sort[%s => %s] ", before.getSort(), after.getSort()));
        }
        return builder.toString();
    }

    @Override
    public String eventName() {
        return "plugin-handle";
    }
}

