/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.RuleConditionDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.common.utils.UUIDUtils;

public final class RuleConditionDO
extends BaseDO {
    private static final long serialVersionUID = -5652026882314490873L;
    private String ruleId;
    private String paramType;
    private String operator;
    private String paramName;
    private String paramValue;

    public RuleConditionDO() {
    }

    public RuleConditionDO(String ruleId, String paramType, String operator, String paramName, String paramValue) {
        this.ruleId = ruleId;
        this.paramType = paramType;
        this.operator = operator;
        this.paramName = paramName;
        this.paramValue = paramValue;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getParamType() {
        return this.paramType;
    }

    public void setParamType(String paramType) {
        this.paramType = paramType;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public String getParamValue() {
        return this.paramValue;
    }

    public void setParamValue(String paramValue) {
        this.paramValue = paramValue;
    }

    public static RuleConditionDOBuilder builder() {
        return new RuleConditionDOBuilder();
    }

    public static RuleConditionDO buildRuleConditionDO(RuleConditionDTO ruleConditionDTO) {
        return Optional.ofNullable(ruleConditionDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            RuleConditionDO ruleConditionDO = RuleConditionDO.builder().paramType(item.getParamType()).ruleId(item.getRuleId()).operator(item.getOperator()).paramName(item.getParamName()).paramValue(((String)StringUtils.defaultIfBlank((CharSequence)item.getParamValue(), (CharSequence)"")).trim()).dateUpdated(currentTime).build();
            if (StringUtils.isEmpty((CharSequence)item.getId())) {
                ruleConditionDO.setId(UUIDUtils.getInstance().generateShortUuid());
                ruleConditionDO.setDateCreated(currentTime);
            } else {
                ruleConditionDO.setId(item.getId());
            }
            return ruleConditionDO;
        }).orElse(null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuleConditionDO that = (RuleConditionDO)o;
        return Objects.equals(this.ruleId, that.ruleId) && Objects.equals(this.paramType, that.paramType) && Objects.equals(this.operator, that.operator) && Objects.equals(this.paramName, that.paramName) && Objects.equals(this.paramValue, that.paramValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.ruleId, this.paramType, this.operator, this.paramName, this.paramValue);
    }

    public static final class RuleConditionDOBuilder {
        private String id;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;
        private String ruleId;
        private String paramType;
        private String operator;
        private String paramName;
        private String paramValue;

        private RuleConditionDOBuilder() {
        }

        public RuleConditionDOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public RuleConditionDOBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public RuleConditionDOBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public RuleConditionDOBuilder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public RuleConditionDOBuilder paramType(String paramType) {
            this.paramType = paramType;
            return this;
        }

        public RuleConditionDOBuilder operator(String operator) {
            this.operator = operator;
            return this;
        }

        public RuleConditionDOBuilder paramName(String paramName) {
            this.paramName = paramName;
            return this;
        }

        public RuleConditionDOBuilder paramValue(String paramValue) {
            this.paramValue = paramValue;
            return this;
        }

        public RuleConditionDO build() {
            RuleConditionDO ruleConditionDO = new RuleConditionDO(this.ruleId, this.paramType, this.operator, this.paramName, this.paramValue);
            ruleConditionDO.setId(this.id);
            ruleConditionDO.setDateCreated(this.dateCreated);
            ruleConditionDO.setDateUpdated(this.dateUpdated);
            return ruleConditionDO;
        }
    }
}

