/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.Objects;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.common.utils.UUIDUtils;

public final class AuthParamDO
extends BaseDO {
    private static final long serialVersionUID = -6719996683886817375L;
    private String authId;
    private String appName;
    private String appParam;

    public AuthParamDO() {
    }

    public AuthParamDO(String authId, String appName, String appParam) {
        this.authId = authId;
        this.appName = appName;
        this.appParam = appParam;
    }

    public String getAuthId() {
        return this.authId;
    }

    public void setAuthId(String authId) {
        this.authId = authId;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppParam() {
        return this.appParam;
    }

    public void setAppParam(String appParam) {
        this.appParam = appParam;
    }

    public static AuthParamDOBuilder builder() {
        return new AuthParamDOBuilder();
    }

    public static AuthParamDO create(String authId, String appName, String appParam) {
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        return AuthParamDO.builder().id(UUIDUtils.getInstance().generateShortUuid()).authId(authId).appName(appName).appParam(appParam).dateUpdated(currentTime).dateCreated(currentTime).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthParamDO that = (AuthParamDO)o;
        return Objects.equals(this.authId, that.authId) && Objects.equals(this.appName, that.appName) && Objects.equals(this.appParam, that.appParam);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.authId, this.appName, this.appParam);
    }

    public static final class AuthParamDOBuilder {
        private String authId;
        private String appName;
        private String appParam;
        private String id;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;

        private AuthParamDOBuilder() {
        }

        public AuthParamDOBuilder authId(String authId) {
            this.authId = authId;
            return this;
        }

        public AuthParamDOBuilder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public AuthParamDOBuilder appParam(String appParam) {
            this.appParam = appParam;
            return this;
        }

        public AuthParamDOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public AuthParamDOBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public AuthParamDOBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public AuthParamDO build() {
            AuthParamDO authParamDO = new AuthParamDO();
            authParamDO.setAuthId(this.authId);
            authParamDO.setAppName(this.appName);
            authParamDO.setAppParam(this.appParam);
            authParamDO.setId(this.id);
            authParamDO.setDateCreated(this.dateCreated);
            authParamDO.setDateUpdated(this.dateUpdated);
            return authParamDO;
        }
    }
}

