/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.shenyu.admin.controller.PagedController;
import org.apache.shenyu.admin.mapper.RuleMapper;
import org.apache.shenyu.admin.model.dto.RuleDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.RuleQuery;
import org.apache.shenyu.admin.model.query.RuleQueryCondition;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.RuleVO;
import org.apache.shenyu.admin.service.PageService;
import org.apache.shenyu.admin.service.RuleService;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/rule"})
public class RuleController
implements PagedController<RuleQueryCondition, RuleVO> {
    private final RuleService ruleService;

    public RuleController(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    @GetMapping(value={""})
    public ShenyuAdminResult queryRules(String selectorId, String name, @RequestParam @NotNull Integer currentPage, @RequestParam @NotNull Integer pageSize) {
        CommonPager<RuleVO> commonPager = this.ruleService.listByPage(new RuleQuery(selectorId, name, new PageParameter(currentPage, pageSize)));
        return ShenyuAdminResult.success("query success", commonPager);
    }

    @GetMapping(value={"/{id}"})
    public ShenyuAdminResult detailRule(@PathVariable(value="id") @Valid @Existed(provider=RuleMapper.class, message="rule is not existed") @Valid @Existed(provider=RuleMapper.class, message="rule is not existed") String id) {
        RuleVO ruleVO = this.ruleService.findById(id);
        return ShenyuAdminResult.success("detail success", ruleVO);
    }

    @PostMapping(value={""})
    public ShenyuAdminResult createRule(@Valid @RequestBody RuleDTO ruleDTO) {
        Integer createCount = this.ruleService.createOrUpdate(ruleDTO);
        return ShenyuAdminResult.success("create success", createCount);
    }

    @PutMapping(value={"/{id}"})
    public ShenyuAdminResult updateRule(@PathVariable(value="id") @Valid @Existed(provider=RuleMapper.class, message="rule is not existed") @Valid @Existed(provider=RuleMapper.class, message="rule is not existed") String id, @Valid @RequestBody RuleDTO ruleDTO) {
        ruleDTO.setId(id);
        Integer updateCount = this.ruleService.createOrUpdate(ruleDTO);
        return ShenyuAdminResult.success("update success", updateCount);
    }

    @DeleteMapping(value={"/batch"})
    public ShenyuAdminResult deleteRules(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        Integer deleteCount = this.ruleService.delete(ids);
        return ShenyuAdminResult.success("delete success", deleteCount);
    }

    @Override
    public PageService<RuleQueryCondition, RuleVO> pageService() {
        return this.ruleService;
    }
}

