/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.Date;
import java.util.List;
import org.apache.shenyu.admin.controller.PagedController;
import org.apache.shenyu.admin.model.entity.OperationRecordLog;
import org.apache.shenyu.admin.model.query.RecordLogQueryCondition;
import org.apache.shenyu.admin.model.result.AdminResult;
import org.apache.shenyu.admin.service.OperationRecordLogService;
import org.apache.shenyu.admin.service.PageService;
import org.apache.shenyu.admin.utils.ResultUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/operation-record/log"})
public class OperationRecordLogController
implements PagedController<RecordLogQueryCondition, OperationRecordLog> {
    private final OperationRecordLogService recordLogService;

    public OperationRecordLogController(OperationRecordLogService recordLogService) {
        this.recordLogService = recordLogService;
    }

    @GetMapping(value={"/list"})
    public AdminResult<List<OperationRecordLog>> list() {
        return ResultUtil.ok(this.recordLogService.list());
    }

    @DeleteMapping(value={"/clean/{timePoint}"})
    @RequiresPermissions(value={"system:role:delete"})
    public AdminResult<Boolean> clean(@PathVariable @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date timePoint) {
        return ResultUtil.ok(this.recordLogService.cleanHistory(timePoint));
    }

    @Override
    public PageService<RecordLogQueryCondition, OperationRecordLog> pageService() {
        return this.recordLogService;
    }
}

