/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.controller.PagedController;
import org.apache.shenyu.admin.mapper.AppAuthMapper;
import org.apache.shenyu.admin.mapper.AuthPathMapper;
import org.apache.shenyu.admin.model.dto.AppAuthDTO;
import org.apache.shenyu.admin.model.dto.AuthApplyDTO;
import org.apache.shenyu.admin.model.dto.AuthPathWarpDTO;
import org.apache.shenyu.admin.model.dto.BatchCommonDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.AppAuthQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.AppAuthVO;
import org.apache.shenyu.admin.service.AppAuthService;
import org.apache.shenyu.admin.service.PageService;
import org.apache.shenyu.admin.service.provider.AppKeyProvider;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/appAuth"})
public class AppAuthController
implements PagedController<AppAuthQuery, AppAuthVO> {
    private final AppAuthService appAuthService;

    public AppAuthController(AppAuthService appAuthService) {
        this.appAuthService = appAuthService;
    }

    @PostMapping(value={"/apply"})
    @RequiresPermissions(value={"system:authen:add"})
    public ShenyuAdminResult apply(@Valid @RequestBody AuthApplyDTO authApplyDTO) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{authApplyDTO.getAppKey()})) {
            return this.appAuthService.applyUpdate(authApplyDTO);
        }
        return this.appAuthService.applyCreate(authApplyDTO);
    }

    @GetMapping(value={"/updateSk"})
    public ShenyuAdminResult updateSk(@RequestParam(value="appKey") @Existed(message="app key not existed", provider=AppKeyProvider.class) @Existed(message="app key not existed", provider=AppKeyProvider.class) String appKey, @RequestParam(value="appSecret") String appSecret) {
        return this.appAuthService.updateAppSecretByAppKey(appKey, appSecret);
    }

    @GetMapping(value={"/findPageByQuery"})
    @RequiresPermissions(value={"system:authen:list"})
    public ShenyuAdminResult findPageByQuery(String appKey, String phone, @RequestParam @NotNull(message="currentPage not null") @NotNull(message="currentPage not null") Integer currentPage, @RequestParam @NotNull(message="pageSize not null") @NotNull(message="pageSize not null") Integer pageSize) {
        AppAuthQuery query = new AppAuthQuery();
        query.setPhone(phone);
        query.setAppKey(appKey);
        query.setPageParameter(new PageParameter(currentPage, pageSize));
        CommonPager<AppAuthVO> commonPager = this.appAuthService.listByPage(query);
        return ShenyuAdminResult.success("query success", commonPager);
    }

    @GetMapping(value={"/detail"})
    @RequiresPermissions(value={"system:authen:editResourceDetails"})
    public ShenyuAdminResult detail(@RequestParam(value="id") @Existed(message="app key not existed", provider=AppAuthMapper.class) @Existed(message="app key not existed", provider=AppAuthMapper.class) String id) {
        return ShenyuAdminResult.success("detail success", this.appAuthService.findById(id));
    }

    @PostMapping(value={"/updateDetail"})
    @RequiresPermissions(value={"system:authen:edit"})
    public ShenyuAdminResult updateDetail(@RequestBody @Valid AppAuthDTO appAuthDTO) {
        return this.appAuthService.updateDetail(appAuthDTO);
    }

    @GetMapping(value={"/detailPath"})
    @RequiresPermissions(value={"system:authen:editResourceDetails"})
    public ShenyuAdminResult detailPath(@RequestParam(value="id") @Existed(message="auth path not existed", providerMethodName="existedByAuthId", provider=AuthPathMapper.class) @NotBlank @Existed(message="auth path not existed", providerMethodName="existedByAuthId", provider=AuthPathMapper.class) @NotBlank String authId) {
        return ShenyuAdminResult.success("detail success", this.appAuthService.detailPath(authId));
    }

    @PostMapping(value={"/updateDetailPath"})
    @RequiresPermissions(value={"system:authen:editResourceDetails"})
    public ShenyuAdminResult updateDetailPath(@RequestBody @Valid AuthPathWarpDTO authPathWarpDTO) {
        return this.appAuthService.updateDetailPath(authPathWarpDTO);
    }

    @PostMapping(value={"/batchDelete"})
    @RequiresPermissions(value={"system:authen:delete"})
    public ShenyuAdminResult batchDelete(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        Integer deleteCount = this.appAuthService.delete(ids);
        return ShenyuAdminResult.success("delete success", deleteCount);
    }

    @PostMapping(value={"/batchEnabled"})
    @RequiresPermissions(value={"system:authen:disable"})
    public ShenyuAdminResult batchEnabled(@Valid @RequestBody BatchCommonDTO batchCommonDTO) {
        String result = this.appAuthService.enabled(batchCommonDTO.getIds(), batchCommonDTO.getEnabled());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{result})) {
            return ShenyuAdminResult.error(result);
        }
        return ShenyuAdminResult.success("enable success");
    }

    @PostMapping(value={"/syncData"})
    @RequiresPermissions(value={"system:authen:modify"})
    public ShenyuAdminResult syncData() {
        return this.appAuthService.syncData();
    }

    @Override
    public PageService<AppAuthQuery, AppAuthVO> pageService() {
        return this.appAuthService;
    }
}

