/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.apache.shenyu.admin.model.dto.AlertTemplateDTO;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.service.AlertTemplateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/alertTemplate"})
public class AlertTemplateController {
    @Autowired
    private AlertTemplateService alertTemplateService;

    @PostMapping(value={"addTemplate"})
    public ShenyuAdminResult addTemplate(@Valid @RequestBody AlertTemplateDTO alertTemplateDTO) {
        int row = this.alertTemplateService.addTemplate(alertTemplateDTO);
        return ShenyuAdminResult.success("create success", row);
    }

    @PostMapping(value={"deleteTemplate"})
    public ShenyuAdminResult deleteTemplate(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        int row = this.alertTemplateService.deleteTemplate(ids);
        return ShenyuAdminResult.success("delete success", row);
    }

    @PostMapping(value={"updateTemplate"})
    public ShenyuAdminResult updateTemplate(@Valid @RequestBody AlertTemplateDTO alertTemplateDTO) {
        int row = this.alertTemplateService.updateTemplate(alertTemplateDTO);
        return ShenyuAdminResult.success("update success", row);
    }

    @GetMapping(value={"getAll"})
    public ShenyuAdminResult getAll() {
        return ShenyuAdminResult.success("query success", this.alertTemplateService.getAll());
    }

    @GetMapping(value={"detail/{id}"})
    public ShenyuAdminResult detail(@PathVariable(value="id") Long id) {
        return ShenyuAdminResult.success("detail success", this.alertTemplateService.detail(id));
    }
}

