/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.spi.singleton;

import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.spi.singleton.SingletonSPI;
import org.apache.shardingsphere.spi.singleton.SingletonSPIRegistry;
import org.apache.shardingsphere.spi.typed.TypedSPI;

public final class TypedSingletonSPIHolder<T extends TypedSPI & SingletonSPI> {
    private final Map<String, T> singletonSPIMap;
    private final boolean typeCaseSensitive;

    public TypedSingletonSPIHolder(Class<T> singletonSPIClass, boolean typeCaseSensitive) {
        this.singletonSPIMap = SingletonSPIRegistry.getSingletonInstancesMap(singletonSPIClass, t -> this.getTypeKey(t.getType(), typeCaseSensitive));
        this.typeCaseSensitive = typeCaseSensitive;
    }

    private String getTypeKey(String type, boolean typeCaseSensitive) {
        return typeCaseSensitive ? type : type.toUpperCase();
    }

    public Optional<T> get(String type) {
        return Optional.ofNullable(this.singletonSPIMap.get(this.getTypeKey(type, this.typeCaseSensitive)));
    }
}

