/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.spring.namespace.parser.strategy;

import com.google.common.base.Strings;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.HintShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public final class ShardingStrategyBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        String type;
        switch (type = element.getLocalName()) {
            case "standard-strategy": {
                return this.getStandardShardingStrategyConfigBeanDefinition(element);
            }
            case "complex-strategy": {
                return this.getComplexShardingStrategyConfigBeanDefinition(element);
            }
            case "hint-strategy": {
                return this.getHintShardingStrategyConfigBeanDefinition(element);
            }
            case "none-strategy": {
                return this.getNoneShardingStrategyConfigBeanDefinition();
            }
        }
        throw new ShardingSphereException("Cannot support type: %s", new Object[]{type});
    }

    private AbstractBeanDefinition getStandardShardingStrategyConfigBeanDefinition(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(StandardShardingStrategyConfiguration.class);
        String shardingColumn = element.getAttribute("sharding-column");
        factory.addConstructorArgValue((Object)(Strings.isNullOrEmpty((String)shardingColumn) ? null : shardingColumn));
        factory.addConstructorArgValue((Object)element.getAttribute("algorithm-ref"));
        return factory.getBeanDefinition();
    }

    private AbstractBeanDefinition getComplexShardingStrategyConfigBeanDefinition(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(ComplexShardingStrategyConfiguration.class);
        factory.addConstructorArgValue((Object)element.getAttribute("sharding-columns"));
        factory.addConstructorArgValue((Object)element.getAttribute("algorithm-ref"));
        return factory.getBeanDefinition();
    }

    private AbstractBeanDefinition getHintShardingStrategyConfigBeanDefinition(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(HintShardingStrategyConfiguration.class);
        factory.addConstructorArgValue((Object)element.getAttribute("algorithm-ref"));
        return factory.getBeanDefinition();
    }

    private AbstractBeanDefinition getNoneShardingStrategyConfigBeanDefinition() {
        return BeanDefinitionBuilder.rootBeanDefinition(NoneShardingStrategyConfiguration.class).getBeanDefinition();
    }
}

