/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.reactive.mysql.command.query.text.fieldlist;

import io.vertx.core.Future;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLBinaryColumnType;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLCharacterSet;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLConstants;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.MySQLColumnDefinition41Packet;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.text.fieldlist.MySQLComFieldListPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLEofPacket;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngineFactory;
import org.apache.shardingsphere.proxy.backend.communication.vertx.VertxDatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseCell;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.mysql.command.ServerStatusFlagCalculator;
import org.apache.shardingsphere.proxy.frontend.reactive.command.executor.ReactiveCommandExecutor;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ReactiveMySQLComFieldListPacketExecutor
implements ReactiveCommandExecutor {
    private static final String SQL = "SHOW COLUMNS FROM %s FROM %s";
    private final MySQLComFieldListPacket packet;
    private final ConnectionSession connectionSession;
    private final String databaseName;
    private final VertxDatabaseCommunicationEngine databaseCommunicationEngine;
    private final int characterSet;
    private int currentSequenceId;

    public ReactiveMySQLComFieldListPacketExecutor(MySQLComFieldListPacket packet, ConnectionSession connectionSession) {
        this.packet = packet;
        this.connectionSession = connectionSession;
        this.databaseName = connectionSession.getDefaultDatabaseName();
        String sql = String.format(SQL, packet.getTable(), this.databaseName);
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        SQLParserRule sqlParserRule = (SQLParserRule)metaDataContexts.getMetaData().getGlobalRuleMetaData().getSingleRule(SQLParserRule.class);
        SQLStatement sqlStatement = sqlParserRule.getSQLParserEngine(DatabaseTypeEngine.getTrunkDatabaseTypeName((DatabaseType)metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType())).parse(sql, false);
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((Map)metaDataContexts.getMetaData().getDatabases(), (SQLStatement)sqlStatement, (String)this.databaseName);
        this.databaseCommunicationEngine = (VertxDatabaseCommunicationEngine)DatabaseCommunicationEngineFactory.getInstance().newDatabaseCommunicationEngine(new QueryContext(sqlStatementContext, sql, Collections.emptyList()), connectionSession.getBackendConnection(), false);
        this.characterSet = ((MySQLCharacterSet)connectionSession.getAttributeMap().attr(MySQLConstants.MYSQL_CHARACTER_SET_ATTRIBUTE_KEY).get()).getId();
    }

    public Future<Collection<DatabasePacket<?>>> executeFuture() {
        return this.databaseCommunicationEngine.executeFuture().compose(unused -> {
            try {
                return Future.succeededFuture(this.createColumnDefinition41Packets());
            }
            catch (SQLException ex) {
                return Future.failedFuture((Throwable)ex);
            }
        });
    }

    private Collection<DatabasePacket<?>> createColumnDefinition41Packets() throws SQLException {
        LinkedList result = new LinkedList();
        while (this.databaseCommunicationEngine.next()) {
            String columnName = ((QueryResponseCell)this.databaseCommunicationEngine.getRowData().getCells().iterator().next()).getData().toString();
            result.add((DatabasePacket<?>)new MySQLColumnDefinition41Packet(++this.currentSequenceId, this.characterSet, this.databaseName, this.packet.getTable(), this.packet.getTable(), columnName, columnName, 100, MySQLBinaryColumnType.MYSQL_TYPE_VARCHAR, 0, true));
        }
        result.add((DatabasePacket<?>)new MySQLEofPacket(++this.currentSequenceId, ServerStatusFlagCalculator.calculateFor((ConnectionSession)this.connectionSession)));
        return result;
    }
}

