/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.merge.result.impl.enumerable;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.Calendar;
import lombok.Generated;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.shardingsphere.infra.merge.result.MergedResult;

public final class EnumerableMergedResult
implements MergedResult {
    private final Enumerable<Object[]> enumerableResult;
    private boolean wasNull;

    @Override
    public boolean next() throws SQLException {
        return this.enumerableResult.enumerator().moveNext();
    }

    @Override
    public Object getValue(int columnIndex, Class<?> type) throws SQLException {
        Object result = ((Object[])this.enumerableResult.enumerator().current())[columnIndex - 1];
        this.wasNull = null == result;
        return result;
    }

    @Override
    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) throws SQLException {
        Object result = ((Object[])this.enumerableResult.enumerator().current())[columnIndex - 1];
        this.wasNull = null == result;
        return result;
    }

    @Override
    public InputStream getInputStream(int columnIndex, String type) throws SQLException {
        return this.getInputStream(((Object[])this.enumerableResult.enumerator().current())[columnIndex - 1]);
    }

    private InputStream getInputStream(Object value) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(value);
        objectOutputStream.flush();
        objectOutputStream.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Generated
    public EnumerableMergedResult(Enumerable<Object[]> enumerableResult) {
        this.enumerableResult = enumerableResult;
    }
}

