/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.protocol;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.binary.BinaryColumnType;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLBinaryColumnType;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.protocol.MySQLBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.protocol.MySQLDateBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.protocol.MySQLDoubleBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.protocol.MySQLFloatBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.protocol.MySQLInt1BinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.protocol.MySQLInt2BinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.protocol.MySQLInt4BinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.protocol.MySQLInt8BinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.protocol.MySQLStringLenencBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.protocol.MySQLTimeBinaryProtocolValue;

public final class MySQLBinaryProtocolValueFactory {
    private static final Map<BinaryColumnType, MySQLBinaryProtocolValue> BINARY_PROTOCOL_VALUES = new HashMap<BinaryColumnType, MySQLBinaryProtocolValue>();

    private static void setStringLenencBinaryProtocolValue() {
        MySQLStringLenencBinaryProtocolValue binaryProtocolValue = new MySQLStringLenencBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_STRING, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_VARCHAR, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_VAR_STRING, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_ENUM, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_SET, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_LONG_BLOB, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_MEDIUM_BLOB, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_BLOB, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_TINY_BLOB, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_GEOMETRY, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_BIT, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_DECIMAL, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_NEWDECIMAL, binaryProtocolValue);
    }

    private static void setInt8BinaryProtocolValue() {
        MySQLInt8BinaryProtocolValue binaryProtocolValue = new MySQLInt8BinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_LONGLONG, binaryProtocolValue);
    }

    private static void setInt4BinaryProtocolValue() {
        MySQLInt4BinaryProtocolValue binaryProtocolValue = new MySQLInt4BinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_LONG, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_INT24, binaryProtocolValue);
    }

    private static void setInt2BinaryProtocolValue() {
        MySQLInt2BinaryProtocolValue binaryProtocolValue = new MySQLInt2BinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_SHORT, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_YEAR, binaryProtocolValue);
    }

    private static void setInt1BinaryProtocolValue() {
        MySQLInt1BinaryProtocolValue binaryProtocolValue = new MySQLInt1BinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_TINY, binaryProtocolValue);
    }

    private static void setDoubleBinaryProtocolValue() {
        MySQLDoubleBinaryProtocolValue binaryProtocolValue = new MySQLDoubleBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_DOUBLE, binaryProtocolValue);
    }

    private static void setFloatBinaryProtocolValue() {
        MySQLFloatBinaryProtocolValue binaryProtocolValue = new MySQLFloatBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_FLOAT, binaryProtocolValue);
    }

    private static void setDateBinaryProtocolValue() {
        MySQLDateBinaryProtocolValue binaryProtocolValue = new MySQLDateBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_DATE, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_DATETIME, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_TIMESTAMP, binaryProtocolValue);
    }

    private static void setTimeBinaryProtocolValue() {
        MySQLTimeBinaryProtocolValue binaryProtocolValue = new MySQLTimeBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_TIME, binaryProtocolValue);
    }

    private static void setNullBinaryProtocolValue() {
        BINARY_PROTOCOL_VALUES.put(MySQLBinaryColumnType.MYSQL_TYPE_NULL, null);
    }

    public static MySQLBinaryProtocolValue getBinaryProtocolValue(BinaryColumnType binaryColumnType) {
        Preconditions.checkArgument((boolean)BINARY_PROTOCOL_VALUES.containsKey(binaryColumnType), (String)"Cannot find MySQL type '%s' in column type when process binary protocol value", (Object)binaryColumnType);
        return BINARY_PROTOCOL_VALUES.get(binaryColumnType);
    }

    @Generated
    private MySQLBinaryProtocolValueFactory() {
    }

    static {
        MySQLBinaryProtocolValueFactory.setStringLenencBinaryProtocolValue();
        MySQLBinaryProtocolValueFactory.setInt8BinaryProtocolValue();
        MySQLBinaryProtocolValueFactory.setInt4BinaryProtocolValue();
        MySQLBinaryProtocolValueFactory.setInt2BinaryProtocolValue();
        MySQLBinaryProtocolValueFactory.setInt1BinaryProtocolValue();
        MySQLBinaryProtocolValueFactory.setDoubleBinaryProtocolValue();
        MySQLBinaryProtocolValueFactory.setFloatBinaryProtocolValue();
        MySQLBinaryProtocolValueFactory.setDateBinaryProtocolValue();
        MySQLBinaryProtocolValueFactory.setTimeBinaryProtocolValue();
        MySQLBinaryProtocolValueFactory.setNullBinaryProtocolValue();
    }
}

