/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.time;

import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLFractionalSeconds {
    private final int fraction;
    private final int fractionalSecondsPrecision;

    public MySQLFractionalSeconds(int columnMeta, MySQLPacketPayload payload) {
        this.fractionalSecondsPrecision = columnMeta;
        this.fraction = this.readFraction(payload);
    }

    private int readFraction(MySQLPacketPayload payload) {
        switch (this.fractionalSecondsPrecision) {
            case 1: 
            case 2: {
                return payload.readInt1() * 10000;
            }
            case 3: 
            case 4: {
                return payload.getByteBuf().readUnsignedShort() * 100;
            }
            case 5: 
            case 6: {
                return payload.getByteBuf().readUnsignedMedium();
            }
        }
        return 0;
    }

    public String toString() {
        if (0 == this.fractionalSecondsPrecision) {
            return "";
        }
        StringBuilder result = new StringBuilder(Integer.toString(this.fraction));
        for (int i = result.length(); i < this.fractionalSecondsPrecision; ++i) {
            result.append("0");
        }
        result.setLength(this.fractionalSecondsPrecision);
        return "." + result;
    }
}

