/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.time;

import java.io.Serializable;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.MySQLBinlogColumnDef;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.MySQLBinlogProtocolValue;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.time.MySQLFractionalSeconds;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLDatetime2BinlogProtocolValue
implements MySQLBinlogProtocolValue {
    @Override
    public Serializable read(MySQLBinlogColumnDef columnDef, MySQLPacketPayload payload) {
        long datetime = this.readDatetimeV2FromPayload(payload);
        return 0L == datetime ? "0000-00-00 00:00:00" : this.readDatetime(columnDef, datetime, payload);
    }

    private long readDatetimeV2FromPayload(MySQLPacketPayload payload) {
        long result = 0L;
        for (int i = 4; i >= 0; --i) {
            result |= (long)payload.readInt1() << 8 * i;
        }
        return result;
    }

    private Serializable readDatetime(MySQLBinlogColumnDef columnDef, long datetime, MySQLPacketPayload payload) {
        long datetimeWithoutSign = datetime & 0x7FFFFFFFFFL;
        return this.readDate(datetimeWithoutSign >> 17) + " " + this.readTime(datetimeWithoutSign % 131072L) + new MySQLFractionalSeconds(columnDef.getColumnMeta(), payload);
    }

    private String readDate(long date) {
        long yearAndMonth = date >> 5;
        return String.format("%d-%02d-%02d", yearAndMonth / 13L, yearAndMonth % 13L, date % 32L);
    }

    private String readTime(long time) {
        return String.format("%02d:%02d:%02d", time >> 12, (time >> 6) % 64L, time % 64L);
    }
}

