/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.constant;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.CommonConstants;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLCharacterSet;

public final class MySQLServerInfo {
    public static final int PROTOCOL_VERSION = 10;
    public static final MySQLCharacterSet DEFAULT_CHARSET = MySQLCharacterSet.UTF8MB4_GENERAL_CI;
    private static String defaultMysqlVersion = "5.7.22";
    private static final String SERVER_VERSION_PATTERN = "%s-ShardingSphere-Proxy %s";
    private static final Map<String, String> SERVER_VERSIONS = new ConcurrentHashMap<String, String>();

    public static void setServerVersion(String databaseName, String serverVersion) {
        SERVER_VERSIONS.put(databaseName, String.format(SERVER_VERSION_PATTERN, serverVersion, CommonConstants.PROXY_VERSION.get()));
    }

    public static String getServerVersion(String databaseName) {
        if (databaseName == null) {
            return MySQLServerInfo.getDefaultServerVersion();
        }
        return SERVER_VERSIONS.getOrDefault(databaseName, MySQLServerInfo.getDefaultServerVersion());
    }

    public static void setDefualtMysqlVersion(String defaultMysqlVersion) {
        MySQLServerInfo.defaultMysqlVersion = defaultMysqlVersion;
    }

    public static String getDefaultServerVersion() {
        return String.format(SERVER_VERSION_PATTERN, defaultMysqlVersion, CommonConstants.PROXY_VERSION.get());
    }

    @Generated
    private MySQLServerInfo() {
    }
}

