/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.constant;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public enum MySQLBinlogEventType {
    UNKNOWN_EVENT(0),
    START_EVENT_V3(1),
    QUERY_EVENT(2),
    STOP_EVENT(3),
    ROTATE_EVENT(4),
    INTVAR_EVENT(5),
    LOAD_EVENT(6),
    SLAVE_EVENT(7),
    CREATE_FILE_EVENT(8),
    APPEND_BLOCK_EVENT(9),
    EXEC_LOAD_EVENT(10),
    DELETE_FILE_EVENT(11),
    NEW_LOAD_EVENT(12),
    RAND_EVENT(13),
    USER_VAR_EVENT(14),
    FORMAT_DESCRIPTION_EVENT(15),
    XID_EVENT(16),
    BEGIN_LOAD_QUERY_EVENT(17),
    EXECUTE_LOAD_QUERY_EVENT(18),
    TABLE_MAP_EVENT(19),
    WRITE_ROWS_EVENTv0(20),
    UPDATE_ROWS_EVENTv0(21),
    DELETE_ROWS_EVENTv0(22),
    WRITE_ROWS_EVENTv1(23),
    UPDATE_ROWS_EVENTv1(24),
    DELETE_ROWS_EVENTv1(25),
    INCIDENT_EVENT(26),
    HEARTBEAT_EVENT(27),
    IGNORABLE_EVENT(28),
    ROWS_QUERY_EVENT(29),
    WRITE_ROWS_EVENTv2(30),
    UPDATE_ROWS_EVENTv2(31),
    DELETE_ROWS_EVENTv2(32),
    GTID_EVENT(33),
    ANONYMOUS_GTID_EVENT(34),
    PREVIOUS_GTIDS_EVENT(35);

    private static final Map<Integer, MySQLBinlogEventType> VALUE_AND_EVENT_TYPE_MAP;
    private final int value;

    public static MySQLBinlogEventType valueOf(int value) {
        if (VALUE_AND_EVENT_TYPE_MAP.containsKey(value)) {
            return VALUE_AND_EVENT_TYPE_MAP.get(value);
        }
        throw new IllegalArgumentException(String.format("Cannot find value '%s' in binlog event type", value));
    }

    @Generated
    private MySQLBinlogEventType(int value) {
        this.value = value;
    }

    @Generated
    public int getValue() {
        return this.value;
    }

    static {
        VALUE_AND_EVENT_TYPE_MAP = new HashMap<Integer, MySQLBinlogEventType>(MySQLBinlogEventType.values().length, 1.0f);
        for (MySQLBinlogEventType each : MySQLBinlogEventType.values()) {
            VALUE_AND_EVENT_TYPE_MAP.put(each.value, each);
        }
    }
}

