/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.spring.namespace.parser;

import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.shardingsphere.dbdiscovery.algorithm.config.AlgorithmProvidedDatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryDataSourceRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryHeartBeatConfiguration;
import org.apache.shardingsphere.dbdiscovery.spring.namespace.factorybean.DatabaseDiscoveryAlgorithmFactoryBean;
import org.apache.shardingsphere.spring.namespace.registry.ShardingSphereAlgorithmBeanRegistry;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public final class DatabaseDiscoveryRuleBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(AlgorithmProvidedDatabaseDiscoveryRuleConfiguration.class);
        factory.addPropertyValue("dataSources", this.parseDatabaseDiscoveryDataSourceRuleConfigurations(element));
        factory.addPropertyValue("discoveryHeartbeats", this.parseDiscoveryHeartbeatsConfigurations(element, parserContext));
        factory.addPropertyValue("discoveryTypes", (Object)ShardingSphereAlgorithmBeanRegistry.getAlgorithmBeanReferences((ParserContext)parserContext, DatabaseDiscoveryAlgorithmFactoryBean.class));
        return factory.getBeanDefinition();
    }

    private List<BeanDefinition> parseDatabaseDiscoveryDataSourceRuleConfigurations(Element element) {
        List dataSourceElements = DomUtils.getChildElementsByTagName((Element)element, (String)"data-source-rule");
        ManagedList result = new ManagedList(dataSourceElements.size());
        for (Element each : dataSourceElements) {
            result.add(this.parseDatabaseDiscoveryDataSourceRuleConfiguration(each));
        }
        return result;
    }

    private BeanDefinition parseDatabaseDiscoveryDataSourceRuleConfiguration(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(DatabaseDiscoveryDataSourceRuleConfiguration.class);
        factory.addConstructorArgValue((Object)element.getAttribute("id"));
        factory.addConstructorArgValue(this.parseDataSources(element));
        factory.addConstructorArgValue((Object)element.getAttribute("discovery-heartbeat-name"));
        factory.addConstructorArgValue((Object)element.getAttribute("discovery-type-name"));
        return factory.getBeanDefinition();
    }

    private Collection<String> parseDataSources(Element element) {
        List dataSources = Splitter.on((String)",").trimResults().splitToList((CharSequence)element.getAttribute("data-source-names"));
        ManagedList result = new ManagedList(dataSources.size());
        result.addAll(dataSources);
        return result;
    }

    private Map<String, BeanDefinition> parseDiscoveryHeartbeatsConfigurations(Element element, ParserContext parserContext) {
        List heartbeatElements = DomUtils.getChildElementsByTagName((Element)element, (String)"discovery-heartbeat");
        ManagedMap result = new ManagedMap(heartbeatElements.size());
        for (Element each : heartbeatElements) {
            result.put(each.getAttribute("id"), this.parseDiscoveryHeartbeatConfiguration(each, parserContext));
        }
        return result;
    }

    private BeanDefinition parseDiscoveryHeartbeatConfiguration(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(DatabaseDiscoveryHeartBeatConfiguration.class);
        factory.addConstructorArgValue((Object)this.parseProperties(element, parserContext));
        return factory.getBeanDefinition();
    }

    private Properties parseProperties(Element element, ParserContext parserContext) {
        Element propsElement = DomUtils.getChildElementByTagName((Element)element, (String)"props");
        return null == propsElement ? new Properties() : parserContext.getDelegate().parsePropsElement(propsElement);
    }
}

