/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.time;

import java.io.Serializable;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.MySQLBinlogColumnDef;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.MySQLBinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLDatetimeBinlogProtocolValue
implements MySQLBinlogProtocolValue {
    @Override
    public Serializable read(MySQLBinlogColumnDef columnDef, MySQLPacketPayload payload) {
        long datetime = payload.readInt8();
        return 0L == datetime ? "0000-00-00 00:00:00" : String.format("%s %s", this.readDate((int)(datetime / 1000000L)), this.readTime((int)(datetime % 1000000L)));
    }

    private String readDate(int date) {
        return String.format("%04d-%02d-%02d", date / 10000, date % 10000 / 100, date % 100);
    }

    private String readTime(int time) {
        return String.format("%02d:%02d:%02d", time / 10000, time % 10000 / 100, time % 100);
    }
}

