/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.string;

import java.io.Serializable;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.MySQLBinlogColumnDef;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.MySQLBinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.string.MySQLJsonValueDecoder;
import org.apache.shardingsphere.database.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLJsonBinlogProtocolValue
implements MySQLBinlogProtocolValue {
    @Override
    public Serializable read(MySQLBinlogColumnDef columnDef, MySQLPacketPayload payload) {
        return MySQLJsonValueDecoder.decode(payload.getByteBuf().readBytes(this.readLengthFromMeta(columnDef.getColumnMeta(), payload)));
    }

    private int readLengthFromMeta(int columnMeta, MySQLPacketPayload payload) {
        switch (columnMeta) {
            case 1: {
                return payload.getByteBuf().readUnsignedByte();
            }
            case 2: {
                return payload.getByteBuf().readUnsignedShortLE();
            }
            case 3: {
                return payload.getByteBuf().readUnsignedMediumLE();
            }
            case 4: {
                return payload.readInt4();
            }
        }
        throw new UnsupportedOperationException("MySQL JSON type meta in binlog should be range 1 to 4, but actual value is: " + columnMeta);
    }
}

