/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.mysql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import org.apache.shardingsphere.database.protocol.codec.DatabasePacketCodecEngine;
import org.apache.shardingsphere.database.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.database.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLPacketCodecEngine
implements DatabasePacketCodecEngine<MySQLPacket> {
    public boolean isValidHeader(int readableBytes) {
        return readableBytes > 4;
    }

    public void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out, int readableBytes) {
        int payloadLength = in.markReaderIndex().readMediumLE();
        int realPacketLength = payloadLength + 3 + 1;
        if (readableBytes < realPacketLength) {
            in.resetReaderIndex();
            return;
        }
        out.add(in.readRetainedSlice(payloadLength + 1));
    }

    public void encode(ChannelHandlerContext context, MySQLPacket message, ByteBuf out) {
        try (MySQLPacketPayload payload = new MySQLPacketPayload(context.alloc().buffer());){
            message.write(payload);
            out.writeMediumLE(payload.getByteBuf().readableBytes());
            out.writeByte(message.getSequenceId());
            out.writeBytes(payload.getByteBuf());
        }
    }

    public MySQLPacketPayload createPacketPayload(ByteBuf message) {
        return new MySQLPacketPayload(message);
    }
}

