/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.datanode;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.apache.shardingsphere.data.pipeline.api.datanode.JobDataNodeEntry;

public final class JobDataNodeLine {
    @NonNull
    private final List<JobDataNodeEntry> entries;

    public static JobDataNodeLine unmarshal(String text) {
        List segments = Splitter.on((char)'|').omitEmptyStrings().splitToList((CharSequence)text);
        ArrayList<JobDataNodeEntry> entries = new ArrayList<JobDataNodeEntry>(segments.size());
        for (String each : segments) {
            entries.add(JobDataNodeEntry.unmarshal(each));
        }
        return new JobDataNodeLine(entries);
    }

    public String marshal() {
        StringBuilder result = new StringBuilder(this.getMarshalledTextEstimatedLength());
        for (JobDataNodeEntry each : this.entries) {
            result.append(each.marshal()).append('|');
        }
        if (!this.entries.isEmpty()) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }

    private int getMarshalledTextEstimatedLength() {
        return this.entries.stream().mapToInt(JobDataNodeEntry::getMarshalledTextEstimatedLength).sum() + this.entries.size();
    }

    @NonNull
    @Generated
    public List<JobDataNodeEntry> getEntries() {
        return this.entries;
    }

    @Generated
    public JobDataNodeLine(@NonNull List<JobDataNodeEntry> entries) {
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        this.entries = entries;
    }

    @Generated
    public String toString() {
        return "JobDataNodeLine(entries=" + this.getEntries() + ")";
    }
}

