/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.config.rulealtered;

import com.google.common.base.Strings;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.HandleConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.PipelineConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.WorkflowConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfigurationFactory;
import org.apache.shardingsphere.data.pipeline.api.job.JobSubType;
import org.apache.shardingsphere.data.pipeline.api.job.JobType;
import org.apache.shardingsphere.data.pipeline.api.job.RuleAlteredJobId;
import org.apache.shardingsphere.data.pipeline.spi.rulealtered.RuleAlteredJobConfigurationPreparer;
import org.apache.shardingsphere.spi.required.RequiredSPIRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobConfiguration.class);
    private WorkflowConfiguration workflowConfig;
    private PipelineConfiguration pipelineConfig;
    private HandleConfiguration handleConfig;

    public JobConfiguration(WorkflowConfiguration workflowConfig, PipelineConfiguration pipelineConfig) {
        this.workflowConfig = workflowConfig;
        this.pipelineConfig = pipelineConfig;
    }

    public void buildHandleConfig() {
        PipelineConfiguration pipelineConfig = this.getPipelineConfig();
        HandleConfiguration handleConfig = this.getHandleConfig();
        if (null == handleConfig || null == handleConfig.getJobShardingDataNodes()) {
            RuleAlteredJobConfigurationPreparer preparer = (RuleAlteredJobConfigurationPreparer)RequiredSPIRegistry.getRegisteredService(RuleAlteredJobConfigurationPreparer.class);
            this.handleConfig = handleConfig = preparer.createHandleConfiguration(pipelineConfig, this.getWorkflowConfig());
        }
        if (null == handleConfig.getJobId()) {
            handleConfig.setJobId(this.generateJobId());
        }
        if (Strings.isNullOrEmpty((String)handleConfig.getSourceDatabaseType())) {
            PipelineDataSourceConfiguration sourceDataSourceConfig = PipelineDataSourceConfigurationFactory.newInstance(pipelineConfig.getSource().getType(), pipelineConfig.getSource().getParameter());
            handleConfig.setSourceDatabaseType(sourceDataSourceConfig.getDatabaseType().getName());
        }
        if (Strings.isNullOrEmpty((String)handleConfig.getTargetDatabaseType())) {
            PipelineDataSourceConfiguration targetDataSourceConfig = PipelineDataSourceConfigurationFactory.newInstance(pipelineConfig.getTarget().getType(), pipelineConfig.getTarget().getParameter());
            handleConfig.setTargetDatabaseType(targetDataSourceConfig.getDatabaseType().getName());
        }
        if (null == handleConfig.getJobShardingItem()) {
            handleConfig.setJobShardingItem(0);
        }
    }

    private String generateJobId() {
        RuleAlteredJobId jobId = new RuleAlteredJobId();
        jobId.setType(JobType.RULE_ALTERED.getValue());
        jobId.setFormatVersion("01");
        jobId.setSubTypes(Collections.singletonList(JobSubType.SCALING.getValue()));
        WorkflowConfiguration workflowConfig = this.getWorkflowConfig();
        jobId.setCurrentMetadataVersion(workflowConfig.getActiveVersion());
        jobId.setNewMetadataVersion(workflowConfig.getNewVersion());
        jobId.setSchemaName(workflowConfig.getSchemaName());
        return jobId.marshal();
    }

    @Generated
    public JobConfiguration() {
    }

    @Generated
    public JobConfiguration(WorkflowConfiguration workflowConfig, PipelineConfiguration pipelineConfig, HandleConfiguration handleConfig) {
        this.workflowConfig = workflowConfig;
        this.pipelineConfig = pipelineConfig;
        this.handleConfig = handleConfig;
    }

    @Generated
    public WorkflowConfiguration getWorkflowConfig() {
        return this.workflowConfig;
    }

    @Generated
    public PipelineConfiguration getPipelineConfig() {
        return this.pipelineConfig;
    }

    @Generated
    public HandleConfiguration getHandleConfig() {
        return this.handleConfig;
    }

    @Generated
    public void setWorkflowConfig(WorkflowConfiguration workflowConfig) {
        this.workflowConfig = workflowConfig;
    }

    @Generated
    public void setPipelineConfig(PipelineConfiguration pipelineConfig) {
        this.pipelineConfig = pipelineConfig;
    }

    @Generated
    public void setHandleConfig(HandleConfiguration handleConfig) {
        this.handleConfig = handleConfig;
    }
}

