/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.socket.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.scala.typeutils.Types;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.types.Row;
import org.apache.seatunnel.flink.BaseFlinkSource;
import org.apache.seatunnel.flink.FlinkEnvironment;
import org.apache.seatunnel.flink.stream.FlinkStreamSource;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={BaseFlinkSource.class})
public class SocketStream
implements FlinkStreamSource {
    private static final long serialVersionUID = 986629276153771291L;
    private Config config;
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final int DEFAULT_PORT = 9999;
    private String host = "localhost";
    private int port = 9999;

    public DataStream<Row> getData(FlinkEnvironment env) {
        StreamExecutionEnvironment environment = env.getStreamExecutionEnvironment();
        return environment.socketTextStream(this.host, this.port).map((MapFunction & Serializable)value -> {
            Row row = new Row(1);
            row.setField(0, value);
            return row;
        }).returns((TypeInformation)new RowTypeInfo(new TypeInformation[]{Types.STRING()}));
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    public void prepare(FlinkEnvironment prepareEnv) {
        if (this.config.hasPath(HOST)) {
            this.host = this.config.getString(HOST);
        }
        if (this.config.hasPath(PORT)) {
            this.port = this.config.getInt(PORT);
        }
    }

    public String getPluginName() {
        return "SocketStream";
    }
}

