/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.function.LongSupplier;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.joda.DateMathParser;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.network.NetworkAddress;
import org.joda.time.DateTimeZone;

public interface DocValueFormat
extends NamedWriteable {
    public static final DocValueFormat RAW = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "raw";
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }

        @Override
        public String format(long value) {
            return Long.toString(value);
        }

        @Override
        public String format(double value) {
            return Double.toString(value);
        }

        @Override
        public String format(BytesRef value) {
            return value.utf8ToString();
        }

        @Override
        public long parseLong(String value, boolean roundUp, LongSupplier now) {
            double d = Double.parseDouble(value);
            d = roundUp ? Math.ceil(d) : Math.floor(d);
            return Math.round(d);
        }

        @Override
        public double parseDouble(String value, boolean roundUp, LongSupplier now) {
            return Double.parseDouble(value);
        }

        @Override
        public BytesRef parseBytesRef(String value) {
            return new BytesRef(value);
        }
    };
    public static final DocValueFormat GEOHASH = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "geo_hash";
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }

        @Override
        public String format(long value) {
            return GeoHashUtils.stringEncode(value);
        }

        @Override
        public String format(double value) {
            return this.format((long)value);
        }

        @Override
        public String format(BytesRef value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long parseLong(String value, boolean roundUp, LongSupplier now) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double parseDouble(String value, boolean roundUp, LongSupplier now) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BytesRef parseBytesRef(String value) {
            throw new UnsupportedOperationException();
        }
    };
    public static final DocValueFormat BOOLEAN = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "bool";
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }

        @Override
        public String format(long value) {
            return Boolean.valueOf(value != 0L).toString();
        }

        @Override
        public String format(double value) {
            return Boolean.valueOf(value != 0.0).toString();
        }

        @Override
        public String format(BytesRef value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long parseLong(String value, boolean roundUp, LongSupplier now) {
            switch (value) {
                case "false": {
                    return 0L;
                }
                case "true": {
                    return 1L;
                }
            }
            throw new IllegalArgumentException("Cannot parse boolean [" + value + "], expected either [true] or [false]");
        }

        @Override
        public double parseDouble(String value, boolean roundUp, LongSupplier now) {
            return this.parseLong(value, roundUp, now);
        }

        @Override
        public BytesRef parseBytesRef(String value) {
            throw new UnsupportedOperationException();
        }
    };
    public static final DocValueFormat IP = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "ip";
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }

        @Override
        public String format(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String format(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String format(BytesRef value) {
            byte[] bytes = Arrays.copyOfRange(value.bytes, value.offset, value.offset + value.length);
            InetAddress inet = InetAddressPoint.decode(bytes);
            return NetworkAddress.format(inet);
        }

        @Override
        public long parseLong(String value, boolean roundUp, LongSupplier now) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double parseDouble(String value, boolean roundUp, LongSupplier now) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BytesRef parseBytesRef(String value) {
            return new BytesRef(InetAddressPoint.encode(InetAddresses.forString(value)));
        }
    };

    public String format(long var1);

    public String format(double var1);

    public String format(BytesRef var1);

    public long parseLong(String var1, boolean var2, LongSupplier var3);

    public double parseDouble(String var1, boolean var2, LongSupplier var3);

    public BytesRef parseBytesRef(String var1);

    public static final class Decimal
    implements DocValueFormat {
        public static final String NAME = "decimal";
        private static final DecimalFormatSymbols SYMBOLS = new DecimalFormatSymbols(Locale.ROOT);
        final String pattern;
        private final NumberFormat format;

        public Decimal(String pattern) {
            this.pattern = pattern;
            this.format = new DecimalFormat(pattern, SYMBOLS);
        }

        public Decimal(StreamInput in) throws IOException {
            this(in.readString());
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.pattern);
        }

        @Override
        public String format(long value) {
            return this.format.format(value);
        }

        @Override
        public String format(double value) {
            return this.format.format(value);
        }

        @Override
        public String format(BytesRef value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long parseLong(String value, boolean roundUp, LongSupplier now) {
            Number n;
            try {
                n = this.format.parse(value);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            if (this.format.isParseIntegerOnly()) {
                return n.longValue();
            }
            double d = n.doubleValue();
            d = roundUp ? Math.ceil(d) : Math.floor(d);
            return Math.round(d);
        }

        @Override
        public double parseDouble(String value, boolean roundUp, LongSupplier now) {
            Number n;
            try {
                n = this.format.parse(value);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            return n.doubleValue();
        }

        @Override
        public BytesRef parseBytesRef(String value) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Decimal that = (Decimal)o;
            return Objects.equals(this.pattern, that.pattern);
        }

        public int hashCode() {
            return Objects.hash(this.pattern);
        }
    }

    public static final class DateTime
    implements DocValueFormat {
        public static final String NAME = "date_time";
        final FormatDateTimeFormatter formatter;
        final DateTimeZone timeZone;
        private final DateMathParser parser;

        public DateTime(FormatDateTimeFormatter formatter, DateTimeZone timeZone) {
            this.formatter = Objects.requireNonNull(formatter);
            this.timeZone = Objects.requireNonNull(timeZone);
            this.parser = new DateMathParser(formatter);
        }

        public DateTime(StreamInput in) throws IOException {
            this(Joda.forPattern(in.readString()), DateTimeZone.forID(in.readString()));
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.formatter.format());
            out.writeString(this.timeZone.getID());
        }

        @Override
        public String format(long value) {
            return this.formatter.printer().withZone(this.timeZone).print(value);
        }

        @Override
        public String format(double value) {
            return this.format((long)value);
        }

        @Override
        public String format(BytesRef value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long parseLong(String value, boolean roundUp, LongSupplier now) {
            return this.parser.parse(value, now, roundUp, this.timeZone);
        }

        @Override
        public double parseDouble(String value, boolean roundUp, LongSupplier now) {
            return this.parseLong(value, roundUp, now);
        }

        @Override
        public BytesRef parseBytesRef(String value) {
            throw new UnsupportedOperationException();
        }
    }
}

