/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.ObjectObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.grouping.CollapseTopFieldDocs;
import org.elasticsearch.action.search.InitialSearchPhase;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.collect.HppcMaps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.pipeline.SiblingPipelineAggregator;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.profile.ProfileShardResult;
import org.elasticsearch.search.profile.SearchProfileShardResults;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;

public final class SearchPhaseController
extends AbstractComponent {
    private static final ScoreDoc[] EMPTY_DOCS = new ScoreDoc[0];
    private final Function<Boolean, InternalAggregation.ReduceContext> reduceContextFunction;

    public SearchPhaseController(Settings settings, Function<Boolean, InternalAggregation.ReduceContext> reduceContextFunction) {
        super(settings);
        this.reduceContextFunction = reduceContextFunction;
    }

    public AggregatedDfs aggregateDfs(Collection<DfsSearchResult> results) {
        ObjectObjectHashMap<Term, TermStatistics> termStatistics = HppcMaps.newNoNullKeysMap();
        ObjectObjectHashMap<String, CollectionStatistics> fieldStatistics = HppcMaps.newNoNullKeysMap();
        long aggMaxDoc = 0L;
        for (DfsSearchResult lEntry : results) {
            Term[] terms = lEntry.terms();
            TermStatistics[] stats = lEntry.termStatistics();
            assert (terms.length == stats.length);
            for (int i = 0; i < terms.length; ++i) {
                assert (terms[i] != null);
                TermStatistics existing = termStatistics.get(terms[i]);
                if (existing != null) {
                    assert (terms[i].bytes().equals(existing.term()));
                    termStatistics.put(terms[i], new TermStatistics(existing.term(), existing.docFreq() + stats[i].docFreq(), SearchPhaseController.optionalSum(existing.totalTermFreq(), stats[i].totalTermFreq())));
                    continue;
                }
                termStatistics.put(terms[i], stats[i]);
            }
            assert (!lEntry.fieldStatistics().containsKey(null));
            Object[] keys = lEntry.fieldStatistics().keys;
            Object[] values = lEntry.fieldStatistics().values;
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i] == null) continue;
                String key = (String)keys[i];
                CollectionStatistics value = (CollectionStatistics)values[i];
                assert (key != null);
                CollectionStatistics existing = fieldStatistics.get(key);
                if (existing != null) {
                    CollectionStatistics merged = new CollectionStatistics(key, existing.maxDoc() + value.maxDoc(), SearchPhaseController.optionalSum(existing.docCount(), value.docCount()), SearchPhaseController.optionalSum(existing.sumTotalTermFreq(), value.sumTotalTermFreq()), SearchPhaseController.optionalSum(existing.sumDocFreq(), value.sumDocFreq()));
                    fieldStatistics.put(key, merged);
                    continue;
                }
                fieldStatistics.put(key, value);
            }
            aggMaxDoc += (long)lEntry.maxDoc();
        }
        return new AggregatedDfs(termStatistics, fieldStatistics, aggMaxDoc);
    }

    private static long optionalSum(long left, long right) {
        return Math.min(left, right) == -1L ? -1L : left + right;
    }

    public SortedTopDocs sortDocs(boolean ignoreFrom, Collection<? extends SearchPhaseResult> results, Collection<TopDocs> bufferedTopDocs, TopDocsStats topDocsStats, int from, int size) {
        boolean hasHits;
        if (results.isEmpty()) {
            return SortedTopDocs.EMPTY;
        }
        ArrayList<TopDocs> topDocs = bufferedTopDocs == null ? new ArrayList<TopDocs>() : bufferedTopDocs;
        HashMap<String, List> groupedCompletionSuggestions = new HashMap<String, List>();
        for (SearchPhaseResult searchPhaseResult : results) {
            QuerySearchResult queryResult = searchPhaseResult.queryResult();
            if (!queryResult.hasConsumedTopDocs()) {
                TopDocs td = queryResult.consumeTopDocs();
                assert (td != null);
                topDocsStats.add(td);
                if (td.scoreDocs.length > 0) {
                    SearchPhaseController.setShardIndex(td, queryResult.getShardIndex());
                    topDocs.add(td);
                }
            }
            if (!queryResult.hasSuggestHits()) continue;
            Suggest shardSuggest = queryResult.suggest();
            for (CompletionSuggestion suggestion : shardSuggest.filter(CompletionSuggestion.class)) {
                suggestion.setShardIndex(searchPhaseResult.getShardIndex());
                List suggestions = groupedCompletionSuggestions.computeIfAbsent(suggestion.getName(), s -> new ArrayList());
                suggestions.add(suggestion);
            }
        }
        boolean bl = hasHits = !(groupedCompletionSuggestions.isEmpty() && topDocs.isEmpty());
        if (hasHits) {
            SortField[] sortFields;
            boolean isSortedByField;
            ScoreDoc[] mergedScoreDocs;
            TopDocs topDocs2 = this.mergeTopDocs(topDocs, size, ignoreFrom ? 0 : from);
            ScoreDoc[] scoreDocs = mergedScoreDocs = topDocs2 == null ? EMPTY_DOCS : topDocs2.scoreDocs;
            if (!groupedCompletionSuggestions.isEmpty()) {
                int numSuggestDocs = 0;
                ArrayList<Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>>> completionSuggestions = new ArrayList<Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>>>(groupedCompletionSuggestions.size());
                for (List groupedSuggestions : groupedCompletionSuggestions.values()) {
                    CompletionSuggestion completionSuggestion = CompletionSuggestion.reduceTo(groupedSuggestions);
                    assert (completionSuggestion != null);
                    numSuggestDocs += completionSuggestion.getOptions().size();
                    completionSuggestions.add(completionSuggestion);
                }
                scoreDocs = new ScoreDoc[mergedScoreDocs.length + numSuggestDocs];
                System.arraycopy(mergedScoreDocs, 0, scoreDocs, 0, mergedScoreDocs.length);
                int offset = mergedScoreDocs.length;
                Suggest suggestions = new Suggest(completionSuggestions);
                for (CompletionSuggestion completionSuggestion : suggestions.filter(CompletionSuggestion.class)) {
                    for (CompletionSuggestion.Entry.Option option : completionSuggestion.getOptions()) {
                        scoreDocs[offset++] = option.getDoc();
                    }
                }
            }
            if (topDocs2 != null && topDocs2 instanceof TopFieldDocs) {
                TopFieldDocs fieldDocs = (TopFieldDocs)topDocs2;
                isSortedByField = !(fieldDocs instanceof CollapseTopFieldDocs && fieldDocs.fields.length == 1 && fieldDocs.fields[0].getType() == SortField.Type.SCORE);
                sortFields = fieldDocs.fields;
            } else {
                isSortedByField = false;
                sortFields = null;
            }
            return new SortedTopDocs(scoreDocs, isSortedByField, sortFields);
        }
        return SortedTopDocs.EMPTY;
    }

    TopDocs mergeTopDocs(Collection<TopDocs> results, int topN, int from) {
        TopDocs mergedTopDocs;
        if (results.isEmpty()) {
            return null;
        }
        assert (!results.isEmpty());
        boolean setShardIndex = false;
        TopDocs topDocs = results.stream().findFirst().get();
        int numShards = results.size();
        if (numShards == 1 && from == 0) {
            return topDocs;
        }
        if (topDocs instanceof CollapseTopFieldDocs) {
            CollapseTopFieldDocs firstTopDocs = (CollapseTopFieldDocs)topDocs;
            Sort sort = new Sort(firstTopDocs.fields);
            CollapseTopFieldDocs[] shardTopDocs = results.toArray(new CollapseTopFieldDocs[numShards]);
            mergedTopDocs = CollapseTopFieldDocs.merge(sort, from, topN, shardTopDocs, false);
        } else if (topDocs instanceof TopFieldDocs) {
            TopFieldDocs firstTopDocs = (TopFieldDocs)topDocs;
            Sort sort = new Sort(firstTopDocs.fields);
            TopFieldDocs[] shardTopDocs = results.toArray(new TopFieldDocs[numShards]);
            mergedTopDocs = TopDocs.merge(sort, from, topN, shardTopDocs, false);
        } else {
            TopDocs[] shardTopDocs = results.toArray(new TopDocs[numShards]);
            mergedTopDocs = TopDocs.merge(from, topN, shardTopDocs, false);
        }
        return mergedTopDocs;
    }

    private static void setShardIndex(TopDocs topDocs, int shardIndex) {
        for (ScoreDoc doc : topDocs.scoreDocs) {
            if (doc.shardIndex != -1) {
                return;
            }
            doc.shardIndex = shardIndex;
        }
    }

    public ScoreDoc[] getLastEmittedDocPerShard(ReducedQueryPhase reducedQueryPhase, int numShards) {
        ScoreDoc[] lastEmittedDocPerShard = new ScoreDoc[numShards];
        if (!reducedQueryPhase.isEmptyResult) {
            ScoreDoc[] sortedScoreDocs = reducedQueryPhase.scoreDocs;
            long size = Math.min(reducedQueryPhase.fetchHits, (long)reducedQueryPhase.size);
            size = Math.min((long)sortedScoreDocs.length, size);
            int sortedDocsIndex = 0;
            while ((long)sortedDocsIndex < size) {
                ScoreDoc scoreDoc;
                lastEmittedDocPerShard[scoreDoc.shardIndex] = scoreDoc = sortedScoreDocs[sortedDocsIndex];
                ++sortedDocsIndex;
            }
        }
        return lastEmittedDocPerShard;
    }

    public IntArrayList[] fillDocIdsToLoad(int numShards, ScoreDoc[] shardDocs) {
        IntArrayList[] docIdsToLoad = new IntArrayList[numShards];
        for (ScoreDoc shardDoc : shardDocs) {
            IntArrayList shardDocIdsToLoad = docIdsToLoad[shardDoc.shardIndex];
            if (shardDocIdsToLoad == null) {
                shardDocIdsToLoad = docIdsToLoad[shardDoc.shardIndex] = new IntArrayList();
            }
            shardDocIdsToLoad.add(shardDoc.doc);
        }
        return docIdsToLoad;
    }

    public InternalSearchResponse merge(boolean ignoreFrom, ReducedQueryPhase reducedQueryPhase, Collection<? extends SearchPhaseResult> fetchResults, IntFunction<SearchPhaseResult> resultsLookup) {
        if (reducedQueryPhase.isEmptyResult) {
            return InternalSearchResponse.empty();
        }
        ScoreDoc[] sortedDocs = reducedQueryPhase.scoreDocs;
        SearchHits hits = this.getHits(reducedQueryPhase, ignoreFrom, fetchResults, resultsLookup);
        if (reducedQueryPhase.suggest != null && !fetchResults.isEmpty()) {
            int currentOffset = hits.getHits().length;
            for (CompletionSuggestion suggestion : reducedQueryPhase.suggest.filter(CompletionSuggestion.class)) {
                List<CompletionSuggestion.Entry.Option> suggestionOptions = suggestion.getOptions();
                for (int scoreDocIndex = currentOffset; scoreDocIndex < currentOffset + suggestionOptions.size(); ++scoreDocIndex) {
                    ScoreDoc shardDoc = sortedDocs[scoreDocIndex];
                    SearchPhaseResult searchResultProvider = resultsLookup.apply(shardDoc.shardIndex);
                    if (searchResultProvider == null) continue;
                    FetchSearchResult fetchResult = searchResultProvider.fetchResult();
                    int index = fetchResult.counterGetAndIncrement();
                    assert (index < fetchResult.hits().getHits().length) : "not enough hits fetched. index [" + index + "] length: " + fetchResult.hits().getHits().length;
                    SearchHit hit = fetchResult.hits().getHits()[index];
                    CompletionSuggestion.Entry.Option suggestOption = suggestionOptions.get(scoreDocIndex - currentOffset);
                    hit.score(shardDoc.score);
                    hit.shard(fetchResult.getSearchShardTarget());
                    suggestOption.setHit(hit);
                }
                currentOffset += suggestionOptions.size();
            }
            assert (currentOffset == sortedDocs.length) : "expected no more score doc slices";
        }
        return reducedQueryPhase.buildResponse(hits);
    }

    private SearchHits getHits(ReducedQueryPhase reducedQueryPhase, boolean ignoreFrom, Collection<? extends SearchPhaseResult> fetchResults, IntFunction<SearchPhaseResult> resultsLookup) {
        boolean sorted = reducedQueryPhase.isSortedByField;
        ScoreDoc[] sortedDocs = reducedQueryPhase.scoreDocs;
        int sortScoreIndex = -1;
        if (sorted) {
            for (int i = 0; i < reducedQueryPhase.sortField.length; ++i) {
                if (reducedQueryPhase.sortField[i].getType() != SortField.Type.SCORE) continue;
                sortScoreIndex = i;
            }
        }
        for (SearchPhaseResult searchPhaseResult : fetchResults) {
            searchPhaseResult.fetchResult().initCounter();
        }
        int from = ignoreFrom ? 0 : reducedQueryPhase.from;
        int n2 = (int)Math.min(reducedQueryPhase.fetchHits - (long)from, (long)reducedQueryPhase.size);
        n2 = Math.min(sortedDocs.length, n2);
        ArrayList<SearchHit> hits = new ArrayList<SearchHit>();
        if (!fetchResults.isEmpty()) {
            for (int i = 0; i < n2; ++i) {
                ScoreDoc shardDoc = sortedDocs[i];
                SearchPhaseResult fetchResultProvider = resultsLookup.apply(shardDoc.shardIndex);
                if (fetchResultProvider == null) continue;
                FetchSearchResult fetchResult = fetchResultProvider.fetchResult();
                int index = fetchResult.counterGetAndIncrement();
                assert (index < fetchResult.hits().getHits().length) : "not enough hits fetched. index [" + index + "] length: " + fetchResult.hits().getHits().length;
                SearchHit searchHit = fetchResult.hits().getHits()[index];
                searchHit.score(shardDoc.score);
                searchHit.shard(fetchResult.getSearchShardTarget());
                if (sorted) {
                    FieldDoc fieldDoc = (FieldDoc)shardDoc;
                    searchHit.sortValues(fieldDoc.fields, reducedQueryPhase.sortValueFormats);
                    if (sortScoreIndex != -1) {
                        searchHit.score(((Number)fieldDoc.fields[sortScoreIndex]).floatValue());
                    }
                }
                hits.add(searchHit);
            }
        }
        return new SearchHits(hits.toArray(new SearchHit[hits.size()]), reducedQueryPhase.totalHits, reducedQueryPhase.maxScore);
    }

    public ReducedQueryPhase reducedQueryPhase(Collection<? extends SearchPhaseResult> queryResults, boolean isScrollRequest) {
        return this.reducedQueryPhase(queryResults, isScrollRequest, true);
    }

    public ReducedQueryPhase reducedQueryPhase(Collection<? extends SearchPhaseResult> queryResults, boolean isScrollRequest, boolean trackTotalHits) {
        return this.reducedQueryPhase(queryResults, null, new ArrayList<TopDocs>(), new TopDocsStats(trackTotalHits), 0, isScrollRequest);
    }

    private ReducedQueryPhase reducedQueryPhase(Collection<? extends SearchPhaseResult> queryResults, List<InternalAggregations> bufferedAggs, List<TopDocs> bufferedTopDocs, TopDocsStats topDocsStats, int numReducePhases, boolean isScrollRequest) {
        List<Object> aggregationsList;
        boolean consumeAggs;
        assert (numReducePhases >= 0) : "num reduce phases must be >= 0 but was: " + numReducePhases;
        ++numReducePhases;
        boolean timedOut = false;
        Boolean terminatedEarly = null;
        if (queryResults.isEmpty()) {
            return new ReducedQueryPhase(topDocsStats.totalHits, topDocsStats.fetchHits, topDocsStats.maxScore, timedOut, terminatedEarly, null, null, null, EMPTY_DOCS, null, null, numReducePhases, false, 0, 0, true);
        }
        QuerySearchResult firstResult = queryResults.stream().findFirst().get().queryResult();
        boolean hasSuggest = firstResult.suggest() != null;
        boolean hasProfileResults = firstResult.hasProfileResults();
        if (bufferedAggs != null) {
            consumeAggs = false;
            assert (firstResult.hasAggs()) : "firstResult has no aggs but we got non null buffered aggs?";
            aggregationsList = bufferedAggs;
        } else if (firstResult.hasAggs()) {
            aggregationsList = new ArrayList(queryResults.size());
            consumeAggs = true;
        } else {
            aggregationsList = Collections.emptyList();
            consumeAggs = false;
        }
        HashMap<String, List<Suggest.Suggestion>> groupedSuggestions = hasSuggest ? new HashMap<String, List<Suggest.Suggestion>>() : Collections.emptyMap();
        HashMap<String, ProfileShardResult> profileResults = hasProfileResults ? new HashMap<String, ProfileShardResult>(queryResults.size()) : Collections.emptyMap();
        int from = 0;
        int size = 0;
        for (SearchPhaseResult searchPhaseResult : queryResults) {
            QuerySearchResult result = searchPhaseResult.queryResult();
            from = result.from();
            size = result.size();
            if (result.searchTimedOut()) {
                timedOut = true;
            }
            if (result.terminatedEarly() != null) {
                if (terminatedEarly == null) {
                    terminatedEarly = result.terminatedEarly();
                } else if (result.terminatedEarly().booleanValue()) {
                    terminatedEarly = true;
                }
            }
            if (hasSuggest) {
                assert (result.suggest() != null);
                for (Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> suggestion : result.suggest()) {
                    List suggestionList = groupedSuggestions.computeIfAbsent(suggestion.getName(), s -> new ArrayList());
                    suggestionList.add(suggestion);
                }
            }
            if (consumeAggs) {
                aggregationsList.add((InternalAggregations)result.consumeAggs());
            }
            if (!hasProfileResults) continue;
            String key = result.getSearchShardTarget().toString();
            profileResults.put(key, result.consumeProfileResult());
        }
        Suggest suggest = groupedSuggestions.isEmpty() ? null : new Suggest(Suggest.reduce(groupedSuggestions));
        InternalAggregation.ReduceContext reduceContext = this.reduceContextFunction.apply(true);
        InternalAggregations aggregations = aggregationsList.isEmpty() ? null : this.reduceAggs(aggregationsList, firstResult.pipelineAggregators(), reduceContext);
        SearchProfileShardResults shardResults = profileResults.isEmpty() ? null : new SearchProfileShardResults(profileResults);
        SortedTopDocs scoreDocs = this.sortDocs(isScrollRequest, queryResults, bufferedTopDocs, topDocsStats, from, size);
        return new ReducedQueryPhase(topDocsStats.totalHits, topDocsStats.fetchHits, topDocsStats.maxScore, timedOut, terminatedEarly, suggest, aggregations, shardResults, scoreDocs.scoreDocs, scoreDocs.sortFields, firstResult != null ? firstResult.sortValueFormats() : null, numReducePhases, scoreDocs.isSortedByField, size, from, firstResult == null);
    }

    private InternalAggregations reduceAggsIncrementally(List<InternalAggregations> aggregationsList) {
        InternalAggregation.ReduceContext reduceContext = this.reduceContextFunction.apply(false);
        return aggregationsList.isEmpty() ? null : this.reduceAggs(aggregationsList, null, reduceContext);
    }

    private InternalAggregations reduceAggs(List<InternalAggregations> aggregationsList, List<SiblingPipelineAggregator> pipelineAggregators, InternalAggregation.ReduceContext reduceContext) {
        InternalAggregations aggregations = InternalAggregations.reduce(aggregationsList, reduceContext);
        if (pipelineAggregators != null) {
            List<InternalAggregation> newAggs = StreamSupport.stream(aggregations.spliterator(), false).map(p -> (InternalAggregation)p).collect(Collectors.toList());
            for (SiblingPipelineAggregator pipelineAggregator : pipelineAggregators) {
                InternalAggregation newAgg = pipelineAggregator.doReduce(new InternalAggregations(newAggs), reduceContext);
                newAggs.add(newAgg);
            }
            return new InternalAggregations(newAggs);
        }
        return aggregations;
    }

    InitialSearchPhase.ArraySearchPhaseResults<SearchPhaseResult> newSearchPhaseResults(SearchRequest request, int numShards) {
        boolean trackTotalHits;
        SearchSourceBuilder source = request.source();
        final boolean isScrollRequest = request.scroll() != null;
        boolean hasAggs = source != null && source.aggregations() != null;
        boolean hasTopDocs = source == null || source.size() != 0;
        boolean bl = trackTotalHits = source == null || source.trackTotalHits();
        if (!isScrollRequest && (hasAggs || hasTopDocs) && request.getBatchedReduceSize() < numShards) {
            return new QueryPhaseResultConsumer(this, numShards, request.getBatchedReduceSize(), hasTopDocs, hasAggs);
        }
        return new InitialSearchPhase.ArraySearchPhaseResults(numShards){

            @Override
            public ReducedQueryPhase reduce() {
                return SearchPhaseController.this.reducedQueryPhase(this.results.asList(), isScrollRequest, trackTotalHits);
            }
        };
    }

    static /* synthetic */ ScoreDoc[] access$400() {
        return EMPTY_DOCS;
    }

    static final class SortedTopDocs {
        static final SortedTopDocs EMPTY = new SortedTopDocs(SearchPhaseController.access$400(), false, null);
        final ScoreDoc[] scoreDocs;
        final boolean isSortedByField;
        final SortField[] sortFields;

        SortedTopDocs(ScoreDoc[] scoreDocs, boolean isSortedByField, SortField[] sortFields) {
            this.scoreDocs = scoreDocs;
            this.isSortedByField = isSortedByField;
            this.sortFields = sortFields;
        }
    }

    static final class TopDocsStats {
        final boolean trackTotalHits;
        long totalHits;
        long fetchHits;
        float maxScore = Float.NEGATIVE_INFINITY;

        TopDocsStats() {
            this(true);
        }

        TopDocsStats(boolean trackTotalHits) {
            this.trackTotalHits = trackTotalHits;
            this.totalHits = trackTotalHits ? 0L : -1L;
        }

        void add(TopDocs topDocs) {
            if (this.trackTotalHits) {
                this.totalHits += topDocs.totalHits;
            }
            this.fetchHits += (long)topDocs.scoreDocs.length;
            if (!Float.isNaN(topDocs.getMaxScore())) {
                this.maxScore = Math.max(this.maxScore, topDocs.getMaxScore());
            }
        }
    }

    static final class QueryPhaseResultConsumer
    extends InitialSearchPhase.ArraySearchPhaseResults<SearchPhaseResult> {
        private final InternalAggregations[] aggsBuffer;
        private final TopDocs[] topDocsBuffer;
        private final boolean hasAggs;
        private final boolean hasTopDocs;
        private final int bufferSize;
        private int index;
        private final SearchPhaseController controller;
        private int numReducePhases = 0;
        private final TopDocsStats topDocsStats = new TopDocsStats();

        private QueryPhaseResultConsumer(SearchPhaseController controller, int expectedResultSize, int bufferSize, boolean hasTopDocs, boolean hasAggs) {
            super(expectedResultSize);
            if (expectedResultSize != 1 && bufferSize < 2) {
                throw new IllegalArgumentException("buffer size must be >= 2 if there is more than one expected result");
            }
            if (expectedResultSize <= bufferSize) {
                throw new IllegalArgumentException("buffer size must be less than the expected result size");
            }
            if (!hasAggs && !hasTopDocs) {
                throw new IllegalArgumentException("either aggs or top docs must be present");
            }
            this.controller = controller;
            this.aggsBuffer = new InternalAggregations[hasAggs ? bufferSize : 0];
            this.topDocsBuffer = new TopDocs[hasTopDocs ? bufferSize : 0];
            this.hasTopDocs = hasTopDocs;
            this.hasAggs = hasAggs;
            this.bufferSize = bufferSize;
        }

        @Override
        public void consumeResult(SearchPhaseResult result) {
            super.consumeResult(result);
            QuerySearchResult queryResult = result.queryResult();
            this.consumeInternal(queryResult);
        }

        private synchronized void consumeInternal(QuerySearchResult querySearchResult) {
            if (this.index == this.bufferSize) {
                if (this.hasAggs) {
                    InternalAggregations reducedAggs = this.controller.reduceAggsIncrementally(Arrays.asList(this.aggsBuffer));
                    Arrays.fill(this.aggsBuffer, null);
                    this.aggsBuffer[0] = reducedAggs;
                }
                if (this.hasTopDocs) {
                    TopDocs reducedTopDocs = this.controller.mergeTopDocs(Arrays.asList(this.topDocsBuffer), querySearchResult.from() + querySearchResult.size(), 0);
                    Arrays.fill(this.topDocsBuffer, null);
                    this.topDocsBuffer[0] = reducedTopDocs;
                }
                ++this.numReducePhases;
                this.index = 1;
            }
            int i = this.index++;
            if (this.hasAggs) {
                this.aggsBuffer[i] = (InternalAggregations)querySearchResult.consumeAggs();
            }
            if (this.hasTopDocs) {
                TopDocs topDocs = querySearchResult.consumeTopDocs();
                this.topDocsStats.add(topDocs);
                SearchPhaseController.setShardIndex(topDocs, querySearchResult.getShardIndex());
                this.topDocsBuffer[i] = topDocs;
            }
        }

        private synchronized List<InternalAggregations> getRemainingAggs() {
            return this.hasAggs ? Arrays.asList(this.aggsBuffer).subList(0, this.index) : null;
        }

        private synchronized List<TopDocs> getRemainingTopDocs() {
            return this.hasTopDocs ? Arrays.asList(this.topDocsBuffer).subList(0, this.index) : null;
        }

        @Override
        public ReducedQueryPhase reduce() {
            return this.controller.reducedQueryPhase(this.results.asList(), this.getRemainingAggs(), this.getRemainingTopDocs(), this.topDocsStats, this.numReducePhases, false);
        }

        int getNumBuffered() {
            return this.index;
        }

        int getNumReducePhases() {
            return this.numReducePhases;
        }
    }

    public static final class ReducedQueryPhase {
        final long totalHits;
        final long fetchHits;
        final float maxScore;
        final boolean timedOut;
        final Boolean terminatedEarly;
        final Suggest suggest;
        final InternalAggregations aggregations;
        final SearchProfileShardResults shardResults;
        final int numReducePhases;
        final ScoreDoc[] scoreDocs;
        final SortField[] sortField;
        final boolean isSortedByField;
        final int size;
        final boolean isEmptyResult;
        final int from;
        final DocValueFormat[] sortValueFormats;

        ReducedQueryPhase(long totalHits, long fetchHits, float maxScore, boolean timedOut, Boolean terminatedEarly, Suggest suggest, InternalAggregations aggregations, SearchProfileShardResults shardResults, ScoreDoc[] scoreDocs, SortField[] sortFields, DocValueFormat[] sortValueFormats, int numReducePhases, boolean isSortedByField, int size, int from, boolean isEmptyResult) {
            if (numReducePhases <= 0) {
                throw new IllegalArgumentException("at least one reduce phase must have been applied but was: " + numReducePhases);
            }
            this.totalHits = totalHits;
            this.fetchHits = fetchHits;
            this.maxScore = Float.isInfinite(maxScore) ? Float.NaN : maxScore;
            this.timedOut = timedOut;
            this.terminatedEarly = terminatedEarly;
            this.suggest = suggest;
            this.aggregations = aggregations;
            this.shardResults = shardResults;
            this.numReducePhases = numReducePhases;
            this.scoreDocs = scoreDocs;
            this.sortField = sortFields;
            this.isSortedByField = isSortedByField;
            this.size = size;
            this.from = from;
            this.isEmptyResult = isEmptyResult;
            this.sortValueFormats = sortValueFormats;
        }

        public InternalSearchResponse buildResponse(SearchHits hits) {
            return new InternalSearchResponse(hits, this.aggregations, this.suggest, this.shardResults, this.timedOut, this.terminatedEarly, this.numReducePhases);
        }
    }
}

