/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.SerializableObject;
import org.apache.lucene.spatial3d.geom.Vector;

public class PlanetModel
implements SerializableObject {
    public static final PlanetModel SPHERE = new PlanetModel(1.0, 1.0);
    public static final double WGS84_MEAN = 6371008.7714;
    public static final double WGS84_POLAR = 6356752.314245;
    public static final double WGS84_EQUATORIAL = 6378137.0;
    public static final PlanetModel WGS84 = new PlanetModel(1.0011188539924791, 0.9977622920221051);
    public final double ab;
    public final double c;
    public final double inverseAb;
    public final double inverseC;
    public final double inverseAbSquared;
    public final double inverseCSquared;
    public final double flattening;
    public final double squareRatio;
    public final double scale;
    public final double inverseScale;
    public final GeoPoint NORTH_POLE;
    public final GeoPoint SOUTH_POLE;
    public final GeoPoint MIN_X_POLE;
    public final GeoPoint MAX_X_POLE;
    public final GeoPoint MIN_Y_POLE;
    public final GeoPoint MAX_Y_POLE;
    public final double minimumPoleDistance;

    public PlanetModel(double ab, double c) {
        this.ab = ab;
        this.c = c;
        this.inverseAb = 1.0 / ab;
        this.inverseC = 1.0 / c;
        this.flattening = (ab - c) * this.inverseAb;
        this.squareRatio = (ab * ab - c * c) / (c * c);
        this.inverseAbSquared = this.inverseAb * this.inverseAb;
        this.inverseCSquared = this.inverseC * this.inverseC;
        this.NORTH_POLE = new GeoPoint(c, 0.0, 0.0, 1.0, 1.5707963267948966, 0.0);
        this.SOUTH_POLE = new GeoPoint(c, 0.0, 0.0, -1.0, -1.5707963267948966, 0.0);
        this.MIN_X_POLE = new GeoPoint(ab, -1.0, 0.0, 0.0, 0.0, -Math.PI);
        this.MAX_X_POLE = new GeoPoint(ab, 1.0, 0.0, 0.0, 0.0, 0.0);
        this.MIN_Y_POLE = new GeoPoint(ab, 0.0, -1.0, 0.0, 0.0, -1.5707963267948966);
        this.MAX_Y_POLE = new GeoPoint(ab, 0.0, 1.0, 0.0, 0.0, 1.5707963267948966);
        this.scale = (2.0 * ab + c) / 3.0;
        this.inverseScale = 1.0 / this.scale;
        this.minimumPoleDistance = Math.min(this.surfaceDistance(this.NORTH_POLE, this.SOUTH_POLE), this.surfaceDistance(this.MIN_X_POLE, this.MAX_X_POLE));
    }

    public PlanetModel(InputStream inputStream) throws IOException {
        this(SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream));
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SerializableObject.writeDouble(outputStream, this.ab);
        SerializableObject.writeDouble(outputStream, this.c);
    }

    public boolean isSphere() {
        return this.ab == this.c;
    }

    public double getMinimumMagnitude() {
        return Math.min(this.ab, this.c);
    }

    public double getMaximumMagnitude() {
        return Math.max(this.ab, this.c);
    }

    public double getMinimumXValue() {
        return -this.ab;
    }

    public double getMaximumXValue() {
        return this.ab;
    }

    public double getMinimumYValue() {
        return -this.ab;
    }

    public double getMaximumYValue() {
        return this.ab;
    }

    public double getMinimumZValue() {
        return -this.c;
    }

    public double getMaximumZValue() {
        return this.c;
    }

    public boolean pointOnSurface(Vector v) {
        return this.pointOnSurface(v.x, v.y, v.z);
    }

    public boolean pointOnSurface(double x, double y, double z) {
        return Math.abs(x * x * this.inverseAb * this.inverseAb + y * y * this.inverseAb * this.inverseAb + z * z * this.inverseC * this.inverseC - 1.0) < 1.0E-12;
    }

    public boolean pointOutside(Vector v) {
        return this.pointOutside(v.x, v.y, v.z);
    }

    public boolean pointOutside(double x, double y, double z) {
        return (x * x + y * y) * this.inverseAb * this.inverseAb + z * z * this.inverseC * this.inverseC - 1.0 > 1.0E-12;
    }

    public GeoPoint createSurfacePoint(Vector vector) {
        return this.createSurfacePoint(vector.x, vector.y, vector.z);
    }

    public GeoPoint createSurfacePoint(double x, double y, double z) {
        double t = Math.sqrt(1.0 / (x * x * this.inverseAbSquared + y * y * this.inverseAbSquared + z * z * this.inverseCSquared));
        return new GeoPoint(t * x, t * y, t * z);
    }

    public GeoPoint bisection(GeoPoint pt1, GeoPoint pt2) {
        double A0 = (pt1.x + pt2.x) * 0.5;
        double B0 = (pt1.y + pt2.y) * 0.5;
        double C0 = (pt1.z + pt2.z) * 0.5;
        double denom = this.inverseAbSquared * A0 * A0 + this.inverseAbSquared * B0 * B0 + this.inverseCSquared * C0 * C0;
        if (denom < 1.0E-12) {
            return null;
        }
        double t = Math.sqrt(1.0 / denom);
        return new GeoPoint(t * A0, t * B0, t * C0);
    }

    public double surfaceDistance(GeoPoint pt1, GeoPoint pt2) {
        double cosSigma;
        double cos2SigmaM;
        double sinSigma;
        double sigma;
        double sinAlpha;
        double cosSqAlpha;
        double C2;
        double L = pt2.getLongitude() - pt1.getLongitude();
        double U1 = Math.atan((1.0 - this.flattening) * Math.tan(pt1.getLatitude()));
        double U2 = Math.atan((1.0 - this.flattening) * Math.tan(pt2.getLatitude()));
        double sinU1 = Math.sin(U1);
        double cosU1 = Math.cos(U1);
        double sinU2 = Math.sin(U2);
        double cosU2 = Math.cos(U2);
        double dCosU1CosU2 = cosU1 * cosU2;
        double dCosU1SinU2 = cosU1 * sinU2;
        double dSinU1SinU2 = sinU1 * sinU2;
        double dSinU1CosU2 = sinU1 * cosU2;
        double lambda = L;
        double lambdaP = Math.PI * 2;
        int iterLimit = 0;
        do {
            double cosLambda;
            double sinLambda;
            if ((sinSigma = Math.sqrt(cosU2 * (sinLambda = Math.sin(lambda)) * (cosU2 * sinLambda) + (dCosU1SinU2 - dSinU1CosU2 * (cosLambda = Math.cos(lambda))) * (dCosU1SinU2 - dSinU1CosU2 * cosLambda))) == 0.0) {
                return 0.0;
            }
            cosSigma = dSinU1SinU2 + dCosU1CosU2 * cosLambda;
            sigma = Math.atan2(sinSigma, cosSigma);
            sinAlpha = dCosU1CosU2 * sinLambda / sinSigma;
            cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
            cos2SigmaM = cosSigma - 2.0 * dSinU1SinU2 / cosSqAlpha;
            if (!Double.isNaN(cos2SigmaM)) continue;
            cos2SigmaM = 0.0;
        } while (Math.abs((lambda = L + (1.0 - (C2 = this.flattening / 16.0 * cosSqAlpha * (4.0 + this.flattening * (4.0 - 3.0 * cosSqAlpha)))) * this.flattening * sinAlpha * (sigma + C2 * sinSigma * (cos2SigmaM + C2 * cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM)))) - (lambdaP = lambda)) >= 1.0E-12 && ++iterLimit < 100);
        double uSq = cosSqAlpha * this.squareRatio;
        double A = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
        double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
        double deltaSigma = B * sinSigma * (cos2SigmaM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM) - B / 6.0 * cos2SigmaM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SigmaM * cos2SigmaM)));
        return this.c * this.inverseScale * A * (sigma - deltaSigma);
    }

    public GeoPoint surfacePointOnBearing(GeoPoint from, double dist, double bearing) {
        double \u03c3\u02b9;
        double cos\u03c3;
        double cos2\u03c3M;
        double sin\u03c3;
        double \u0394\u03c3;
        double lat = from.getLatitude();
        double lon = from.getLongitude();
        double sin\u03b11 = Math.sin(bearing);
        double cos\u03b11 = Math.cos(bearing);
        double tanU1 = (1.0 - this.flattening) * Math.tan(lat);
        double cosU1 = 1.0 / Math.sqrt(1.0 + tanU1 * tanU1);
        double sinU1 = tanU1 * cosU1;
        double \u03c31 = Math.atan2(tanU1, cos\u03b11);
        double sin\u03b1 = cosU1 * sin\u03b11;
        double cosSq\u03b1 = 1.0 - sin\u03b1 * sin\u03b1;
        double uSq = cosSq\u03b1 * this.squareRatio;
        double A = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
        double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
        double \u03c3 = dist / (this.c * this.inverseScale * A);
        double iterations = 0.0;
        do {
            cos2\u03c3M = Math.cos(2.0 * \u03c31 + \u03c3);
        } while (Math.abs((\u03c3 = dist / (this.c * this.inverseScale * A) + (\u0394\u03c3 = B * (sin\u03c3 = Math.sin(\u03c3)) * (cos2\u03c3M + B / 4.0 * ((cos\u03c3 = Math.cos(\u03c3)) * (-1.0 + 2.0 * cos2\u03c3M * cos2\u03c3M) - B / 6.0 * cos2\u03c3M * (-3.0 + 4.0 * sin\u03c3 * sin\u03c3) * (-3.0 + 4.0 * cos2\u03c3M * cos2\u03c3M))))) - (\u03c3\u02b9 = \u03c3)) >= 1.0E-12 && (iterations += 1.0) < 100.0);
        double x = sinU1 * sin\u03c3 - cosU1 * cos\u03c3 * cos\u03b11;
        double \u03c62 = Math.atan2(sinU1 * cos\u03c3 + cosU1 * sin\u03c3 * cos\u03b11, (1.0 - this.flattening) * Math.sqrt(sin\u03b1 * sin\u03b1 + x * x));
        double \u03bb = Math.atan2(sin\u03c3 * sin\u03b11, cosU1 * cos\u03c3 - sinU1 * sin\u03c3 * cos\u03b11);
        double C2 = this.flattening / 16.0 * cosSq\u03b1 * (4.0 + this.flattening * (4.0 - 3.0 * cosSq\u03b1));
        double L = \u03bb - (1.0 - C2) * this.flattening * sin\u03b1 * (\u03c3 + C2 * sin\u03c3 * (cos2\u03c3M + C2 * cos\u03c3 * (-1.0 + 2.0 * cos2\u03c3M * cos2\u03c3M)));
        double \u03bb2 = (lon + L + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        return new GeoPoint(this, \u03c62, \u03bb2);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PlanetModel)) {
            return false;
        }
        PlanetModel other = (PlanetModel)o;
        return this.ab == other.ab && this.c == other.c;
    }

    public int hashCode() {
        return Double.hashCode(this.ab) + Double.hashCode(this.c);
    }

    public String toString() {
        if (this.equals(SPHERE)) {
            return "PlanetModel.SPHERE";
        }
        if (this.equals(WGS84)) {
            return "PlanetModel.WGS84";
        }
        return "PlanetModel(ab=" + this.ab + " c=" + this.c + ")";
    }
}

