/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.join.DocValuesTermsCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;

abstract class TermsCollector<DV>
extends DocValuesTermsCollector<DV> {
    final BytesRefHash collectorTerms = new BytesRefHash();

    TermsCollector(DocValuesTermsCollector.Function<DV> docValuesCall) {
        super(docValuesCall);
    }

    public BytesRefHash getCollectorTerms() {
        return this.collectorTerms;
    }

    static TermsCollector<?> create(String field, boolean multipleValuesPerDocument) {
        return multipleValuesPerDocument ? new MV(TermsCollector.sortedSetDocValues(field)) : new SV(TermsCollector.binaryDocValues(field));
    }

    @Override
    public boolean needsScores() {
        return false;
    }

    static class SV
    extends TermsCollector<BinaryDocValues> {
        SV(DocValuesTermsCollector.Function<BinaryDocValues> docValuesCall) {
            super(docValuesCall);
        }

        @Override
        public void collect(int doc) throws IOException {
            BytesRef term = ((BinaryDocValues)this.docValues).advanceExact(doc) ? ((BinaryDocValues)this.docValues).binaryValue() : new BytesRef(BytesRef.EMPTY_BYTES);
            this.collectorTerms.add(term);
        }
    }

    static class MV
    extends TermsCollector<SortedSetDocValues> {
        MV(DocValuesTermsCollector.Function<SortedSetDocValues> docValuesCall) {
            super(docValuesCall);
        }

        @Override
        public void collect(int doc) throws IOException {
            if (doc > ((SortedSetDocValues)this.docValues).docID()) {
                ((SortedSetDocValues)this.docValues).advance(doc);
            }
            if (doc == ((SortedSetDocValues)this.docValues).docID()) {
                long ord;
                while ((ord = ((SortedSetDocValues)this.docValues).nextOrd()) != -1L) {
                    BytesRef term = ((SortedSetDocValues)this.docValues).lookupOrd(ord);
                    this.collectorTerms.add(term);
                }
            }
        }
    }
}

