/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.LongDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueLong;

public class LongFieldSource
extends FieldCacheSource {
    public LongFieldSource(String field) {
        super(field);
    }

    @Override
    public String description() {
        return "long(" + this.field + ')';
    }

    public long externalToLong(String extVal) {
        return Long.parseLong(extVal);
    }

    public Object longToObject(long val) {
        return val;
    }

    public String longToString(long val) {
        return this.longToObject(val).toString();
    }

    @Override
    public SortField getSortField(boolean reverse) {
        return new SortField(this.field, SortField.Type.LONG, reverse);
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final NumericDocValues arr = this.getNumericDocValues(context, readerContext);
        return new LongDocValues(this){
            int lastDocID;

            private long getValueForDoc(int doc) throws IOException {
                if (doc < this.lastDocID) {
                    throw new IllegalArgumentException("docs were sent out-of-order: lastDocID=" + this.lastDocID + " vs docID=" + doc);
                }
                this.lastDocID = doc;
                int curDocID = arr.docID();
                if (doc > curDocID) {
                    curDocID = arr.advance(doc);
                }
                if (doc == curDocID) {
                    return arr.longValue();
                }
                return 0L;
            }

            @Override
            public long longVal(int doc) throws IOException {
                return this.getValueForDoc(doc);
            }

            @Override
            public boolean exists(int doc) throws IOException {
                this.getValueForDoc(doc);
                return arr.docID() == doc;
            }

            @Override
            public Object objectVal(int doc) throws IOException {
                long value = this.getValueForDoc(doc);
                if (arr.docID() == doc) {
                    return LongFieldSource.this.longToObject(value);
                }
                return null;
            }

            @Override
            public String strVal(int doc) throws IOException {
                long value = this.getValueForDoc(doc);
                if (arr.docID() == doc) {
                    return LongFieldSource.this.longToString(value);
                }
                return null;
            }

            @Override
            protected long externalToLong(String extVal) {
                return LongFieldSource.this.externalToLong(extVal);
            }

            @Override
            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueLong mval;
                    {
                        this.mval = LongFieldSource.this.newMutableValueLong();
                    }

                    @Override
                    public MutableValue getValue() {
                        return this.mval;
                    }

                    @Override
                    public void fillValue(int doc) throws IOException {
                        this.mval.value = this.getValueForDoc(doc);
                        this.mval.exists = arr.docID() == doc;
                    }
                };
            }
        };
    }

    protected NumericDocValues getNumericDocValues(Map context, LeafReaderContext readerContext) throws IOException {
        return DocValues.getNumeric(readerContext.reader(), this.field);
    }

    protected MutableValueLong newMutableValueLong() {
        return new MutableValueLong();
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != this.getClass()) {
            return false;
        }
        LongFieldSource other = (LongFieldSource)o;
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        int h = this.getClass().hashCode();
        return h += super.hashCode();
    }
}

